/****************************************************************************/

/* 

hack1.c
The same pumping heuristic from:
http://www.cc.gatech.edu/grads/b/Gary.N.Boone/acrobot/acrobot.html
But this time I'm collecting data....

plan2.c
Modified get_in_table function...

plan1.c
Now we have the two arm version - let's see what happens!!!

plan5.c 
This version gets the command signal that is written to the file from the 
332, not the sun's current command.  This should help with the data 
analysis since the sun command was lagging the command being given.

plan4.c
This version loads the constants from sim* from a file (command.info).  
Another data file is written at the end which is also the same as the data 
file written by the data logger.  This way, the same parameter id stuff can be 
used to get parameters off of this data.  The file i called id.dat.
pos vel acc sin(angle) command int(sin) int(command)

plan3.c 

This programs cleans up a lot of the code, assumes that it can always get 
current info from the 332 and attempts to send the command back.  All of 
the info processing is done on the 332 and then it is sent to the sun.

plan1.c
This program reads in the array from command.dat.  Then it issues the 
send packets command to the 332.  Upon receiving an info packet from the 
332, they are processed and the appropriate command is found in the 
command array.  This command is sent to the 332 and the next packet is 
read in and worked on.

The state and time and command-given are also stored in an array and then 
written to a file called data.dat.
time pos vel command 

/****************************************************************************/
/* Include files */

#include <stdio.h>
#include <sgtty.h>
#include <sys/fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/conf.h>
#include <stropts.h>
#include <errno.h>
#include <math.h>

/****************************************************************************/
/****************************************************************************/
/* Constants */

#define TRUE 1
#define FALSE 0
#define N_VARIABLES 6
#define N_POINTS 1000
#define N_ID_VARIABLES 7 /* needs to be modified */
#define N_CON 18

#define POSITIVE 2
#define NEGATIVE 1
#define ZERO 0

#define PI 3.1416
#define COUNTS_PER_REV 2000

/* Globals */

int count_a = 0;
int count_b = 0;
int errors_a = 0;
int errors_b = 0;

int packet_id_sent = 0;
char user_input;
int save_info = FALSE;
int time, pos_1, vel_1, pos_2, vel_2;
int data_array_index = 0;
float float_time;
int command_332;

int pump;

/* arrays */

float data_array[N_POINTS][N_VARIABLES];
float id_data_array[N_POINTS][N_ID_VARIABLES];
/* structures */
    
typedef struct STATE_STRUCT {
        float pos_1;
        float vel_1; 
        float pos_2;
        float vel_2; 
}
STATE;

typedef struct INDICES_STRUCT {
        int pos_1;   
        int vel_1;
        int pos_2;   
        int vel_2;
}
INDICES;

/*************************************************************************/
/****************************************************************************/
initialize()  {
/* initializes the data array */

  int point, variable;

  for ( point = 0; point < N_POINTS; point++ )  {
	for ( variable = 0; variable < N_VARIABLES; variable++ )  {
		data_array[point][variable] = 0.0;
	}
  }

}

/*************************************************************************/
/****************************************************************************/
print_help()  {

  printf( "\n" );
  printf( "Enter i to initialize the data array.\n" );
  printf( "Enter z to zero the encoders.\n" );
  printf( "Enter p to send a positive command.\n" );
  printf( "Enter n to send a negative command.\n" );
  printf( "Enter q to send a zero command.\n" );
  printf( "Enter r to run pend from the pumping heuristic and record info.\n" );
  printf( "Enter w to run pend from the heuristic w/o recording.\n" );
  printf( "Enter e to get the 332 to stop sending data (debug command).\n" );
  printf( "Enter x to exit.\n\n" );
  printf( "Simon says > " );
  
}

/****************************************************************************/
/****************************************************************************/
receive_data()  {
/* looks for data from the 332 N_POINTS times */

  int count = 0;
  int point = 0;

  data_array_index = 0;

  for( point = 0; point < N_POINTS ; point++ )  {
	/* actually gets the state of the system */
	process_packet();

	/* a true HACK to solve the serial line clearing problem */
	if ( time == 0 )  {
		point = 0;
		printf( "Zero time reached!\n" );
	}		

	/* give me some feedback every so often if something has gone wrong */
	if ( count >= 10 && errors_a != 0 ) {
		/* printf( "%d: errors: %d\n", point, errors_a ); */
		count = 0;
	}
	else
		count++;

	/* figure out what to do and send command */
	take_action();

	/* stick it in the array */
	store_data( point );

  }

  /* make sure to turn the motor off */
  send_command( 0 );

  /* tell the 332 to stop sending data */
  packet_id_sent = 5; /* tells 332 to stop send data */
  send_packet();

  /* reset error counter */
  errors_a = 0;

  if ( save_info )  {
	printf( "Writing data file.\n" );
	write_data_file(); 
	printf( "Data file data.dat written. \n" );
	printf( "Making the id data file.\n" );
	make_id_data();
	write_id_data_file();
	printf( "Id data file id.dat written.\n" );
  }

}

/*************************************************************************/
/****************************************************************************/
process_packet()  {
/* reads in the packets from the 332 */

  int value;
  int packet_id;

  /* check for handshake */
  while( ( value = read_c_a() ) != 0xff )
    {
      printf( "s1: got error: %d; value: %d %c \n",
	      errors_a, value, value & 0xff );
      errors_a++;
    }

  /* read the packet_id */
  packet_id = read_c_a();
  /* printf( "packet_id: %d\n", packet_id ); */
  /* reads the data */
  time = read_int_32_a();
  float_time = time;
  float_time = float_time / 1000;  /* puts in seconds */
  pos_1 = read_int_32_a();  /* in encoder counts */
  vel_1 = read_int_32_a();  /* in encoder counts per second */
  pos_2 = read_int_32_a();  /* in encoder counts */
  vel_2 = read_int_32_a();  /* in encoder counts per second */
  command_332 = read_int_32_a(); /* 332's motor command */

}

/****************************************************************************/
/****************************************************************************/
send_command( table_command )
	int table_command;
{
/* picks the correct packet_id number to send based on the command */

  switch ( table_command )  {
	case 0:  /* do nothing */
		packet_id_sent = 1;
	break;
	case 1:  /* go negative */
		packet_id_sent = 3;
	break;
	case 2:  /* go positive */
		packet_id_sent = 2;
	break;
	default:  /* do nothing */
		packet_id_sent = 1;
	break;
  }

  send_packet();

}

/****************************************************************************/
/****************************************************************************/
take_action()  {

  int command;

  if ( pump )  {
        if ( vel_1 > 0 )
                command = NEGATIVE;
        if ( vel_1 < 0 )
                command = POSITIVE;
  }
  else
	command = ZERO;
                                              
  send_command( command );

}

/*************************************************************************/
/*************************************************************************/
send_packet()  {
/* sends a packet of info to the 332 */

  /* handshake */
  send_c_a( 0xff );
  /* send info (only an id number) */
  send_c_a( packet_id_sent );
  /* printf( "init packet sent.\n" ); */
}

/****************************************************************************/
/****************************************************************************/
store_data( point )  
	int point;
{
/* stores the data in an array */

  if (point < N_POINTS)
    {
      data_array[point][0] = float_time;
      data_array[point][1] = (float) pos_1;
      data_array[point][2] = (float) vel_1;
      data_array[point][3] = (float) pos_2;
      data_array[point][4] = (float) vel_2;
      data_array[point][5] = (float) command_332;
      /* second index should be less than N_VARIABLES */
    }

}

/****************************************************************************/
/****************************************************************************/
float get_radians( encoder )
        float encoder;
{
        
  float radians;
        
  radians = encoder * PI * 2 / COUNTS_PER_REV;
  return( radians ); 
        
}
        
/****************************************************************************/
/****************************************************************************/
make_id_data()  {
/* makes the parameter identification data */

/* NEEDS MODIFICATION!!!! */

  int point, variable, n_id_points;
  float delta_time, angle_pos, angle_vel, angle_acc;
  float torque_sign, int_sin, int_torque; 

  n_id_points = N_POINTS - 1;
  int_sin = 0;
  int_torque = 0;

  for ( point = 0; point < n_id_points; point++ )  {

        /* get delta time */
        delta_time = data_array[point + 1][0] -
                data_array[point][0];

	/* angle */
	angle_pos = data_array[point][1];  /* in encoder counts */
	angle_pos = get_radians( angle_pos );
	id_data_array[point][0] = angle_pos;

	/* angular velocity */
	angle_vel = data_array[point][2];  /* in encoder counts */
	angle_vel = get_radians( angle_vel );
	id_data_array[point][1] = angle_vel;

	/* angular acceleration */
	angle_acc = (data_array[point + 1][2] 
		- data_array[point][2]) / delta_time;  /* in encoder counts */
	angle_acc = get_radians( angle_acc );
	id_data_array[point][2] = angle_acc;
  
	/* sin ( angle ) */
	id_data_array[point][3] = sin( angle_pos );

	/* command */
	switch( data_array[point][3] )  {
                case 0: /* zero */
                        torque_sign = 0;
                break;
                case 1: /* negative */
                        torque_sign = -1;
                break;
                case 2: /* positive */
                        torque_sign = 1;
                break;
        }
        id_data_array[point][4] = torque_sign;

	/* int ( sin ) */
        int_sin = int_sin + sin( angle_pos ) * delta_time;
        id_data_array[point][5] = int_sin;

	/* int ( command ) */
        int_torque = int_torque + torque_sign * delta_time; 
        id_data_array[point][6] = int_torque;
  }

}

/****************************************************************************/
/****************************************************************************/
write_id_data_file()  {
/* writes the id data in the array to a file */

  FILE *fd;
  int point, variable, n_id_points;

  n_id_points = N_POINTS - 1;

  if ( ( fd = fopen( "id.dat", "w" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file id.dat for write.\n" );
  }
  for ( point = 0; point < n_id_points ; point++ )  {
      for ( variable = 0; variable < N_ID_VARIABLES; variable++ )  {
	  fprintf( fd, "%f ", id_data_array[point][variable] );
      }
      fprintf( fd, "\n" );
  }
  fclose( fd );

}

/****************************************************************************/
/****************************************************************************/
write_data_file()  {
/* writes the data in the array to a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "data.dat", "w" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file data.dat for write.\n" );
  }
  for ( point = 0; point < N_POINTS; point++ )  {
      for ( variable = 0; variable < N_VARIABLES; variable++ )  {
	  fprintf( fd, "%f ", data_array[point][variable] );
      }
      fprintf( fd, "\n" );
  }
  fclose( fd );

}

/****************************************************************************/
/****************************************************************************/
main( argc, argv )
int argc;
char *argv[];
{
  init_serial_io( argc, argv );

  while ( 1 )  {

  	print_help();
  	user_input = getchar();
  	switch (user_input)  {
   		case 'i': /* initialize data array */
			initialize();
  		break;
		case 'x':  /* exit the program */
			exit ( 0 );
		break;
		case 'r':  /* use command array to run and save data */
			printf( "\nMake sure zero time is reached!\n" );
			save_info = TRUE;
			packet_id_sent = 4; /* tells the 332 to send data */
			pump = TRUE;
			send_packet();
			receive_data();  /* receive, process, command */
			pump = FALSE;
		break;
		case 'z':  /* zero the encoders */
			pump = FALSE;
			packet_id_sent = 6;
			send_packet();
		break;
		case 'w':  /* run w/o collecting data */
			save_info = FALSE;
			pump = TRUE;
			packet_id_sent = 4; /* tells the 332 to send data */
			send_packet();
			receive_data();  /* receive, process, command */
			pump = FALSE;
		break;
		case 'e':  /* tells the 332 to stop sending data */
			pump = FALSE;
			packet_id_sent = 5; /* tells 332 to stop send data */
                        send_packet();
		break;
		case 'p':  /* send positive command */
			pump = FALSE;
			packet_id_sent = 2;  /* positive packet id */
			send_packet();
		break;
		case 'n':  /* send negative command */
			pump = FALSE;
			packet_id_sent = 3;  /* negative packet id */
			send_packet();
		break;
		case 'q':  /* send zero command */
			pump = FALSE;
			packet_id_sent = 1;  /* zero packet id */
			send_packet();
		break;
		}
  }			

}

/*************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/* STUFF FOR SERIAL PORT */
/*************************************************************************/

#define BUFFSIZE (FMNAMESZ+1)

char buff_a[BUFFSIZE];
char buff_b[BUFFSIZE];

char *ProgName;

struct sgttyb	osavrem_a,	/* original remote tty state */
		nsavrem_a;	/* new remote tty state */
struct sgttyb	osavrem_b,	/* original remote tty state */
		nsavrem_b;	/* new remote tty state */

int rem_a;
int rem_b;

char *remdev_a = "/dev/ttya";
char *remdev_b = "/dev/ttyb";

char strip_parity = 0xff;

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

init_serial_io(argc, argv)
int argc;
char *argv[];
{
  int status;

  /* char sgspeed = B9600; */
  /* char sgspeed = B19200; */
  char sgspeed = B38400;

  if ((rem_a = open(remdev_a, O_RDWR /*|| O_NDELAY*/)) < 0)
    {
      fprintf(stderr,"Can't open tty line %s!\n",remdev_a);
      perror("open");
      exit(1);
    }
  if ((rem_b = open(remdev_b, O_RDWR /*|| O_NDELAY*/)) < 0)
    {
      fprintf(stderr,"Can't open tty line %s!\n",remdev_b);
      perror("open");
      exit(1);
    }

  ioctl(rem_a, TIOCGETP, &osavrem_a);
  ioctl(rem_b, TIOCGETP, &osavrem_b);

  nsavrem_a = osavrem_a;
  nsavrem_b = osavrem_b;

  if(sgspeed)
    {
      nsavrem_a.sg_ispeed = sgspeed;
      nsavrem_a.sg_ospeed = sgspeed;
      nsavrem_b.sg_ispeed = sgspeed;
      nsavrem_b.sg_ospeed = sgspeed;
    }

  nsavrem_a.sg_flags &= ~ECHO; 
  nsavrem_a.sg_flags |= RAW|TANDEM;
  nsavrem_b.sg_flags &= ~ECHO; 
  nsavrem_b.sg_flags |= RAW|TANDEM;

  ioctl(rem_a, TIOCSETP, &nsavrem_a);
  ioctl(rem_a, TIOCEXCL, NULL);
  ioctl(rem_a, TIOCHPCL, NULL); 
  ioctl(rem_b, TIOCSETP, &nsavrem_b);
  ioctl(rem_b, TIOCEXCL, NULL);
  ioctl(rem_b, TIOCHPCL, NULL); 
  fcntl(rem_a, F_SETFL, O_SYNC);
  fcntl(rem_a, F_SETFL, FNDELAY);
  fcntl(rem_b, F_SETFL, O_SYNC);
  fcntl(rem_b, F_SETFL, FNDELAY);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

/* no hang version */
read_c_a_no_hang()
{
  int value, bytes_read;
  int i;

  bytes_read = read(rem_a, buff_a, 1);
  if ( bytes_read > 0 )
    {
      value = buff_a[0] & 0xff;
      return value;
    }
  else
    return -1;
}

/*************************************************************************/

/*************************************************************************/

/* no hang version */
read_c_b_no_hang()
{
  int value, bytes_read;
  int i;

  bytes_read = read(rem_b, buff_b, 1);
  if ( bytes_read > 0 )
    {
      value = buff_b[0] & 0xff;
      return value;
    }
  else
    return -1;
}

/*************************************************************************/

read_c_a()
{
  int value, bytes_read;
  int i;

  bytes_read = 0;
  while (bytes_read <= 0)
    {
      bytes_read = read(rem_a, buff_a, 1);
    }
  value = buff_a[0] & 0xff;
  return value;
}

/*************************************************************************/

read_c_b()
{
  int value, bytes_read;
  int i;

  bytes_read = 0;
  while (bytes_read <= 0)
    {
      bytes_read = read(rem_b, buff_b, 1);
    }
  value = buff_b[0] & 0xff;
  return value;
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

send_c_a( c )
     int c;
{
  int i;

  buff_a[ 0 ] = c & 0xff;
  write(rem_a, buff_a, 1);
}

/*************************************************************************/

send_c_b( c )
     int c;
{
  buff_b[ 0 ] = c & 0xff;
  write(rem_b, buff_b, 1);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/


finish()
{
  exit(0);
  ioctl(rem_a, TIOCSETP, &osavrem_a);
  ioctl(rem_a, TIOCNXCL, NULL);
  ioctl(rem_b, TIOCSETP, &osavrem_b);
  ioctl(rem_b, TIOCNXCL, NULL);
}

/*************************************************************************/
/****************************************************************************/

static read_int_16_a()
{
  int i;
  
  i = 0;
  i += read_c_a();
  i += read_c_a() << 8; 
  if ( i & 0x8000 )
    i |= 0xffff0000;
  return i;
}

/****************************************************************************/

static read_int_32_a()
{
  int i;
  
  i = 0;
  i += read_c_a();
  i += read_c_a() << 8; 
  i += read_c_a() << 16; 
  i += read_c_a() << 24; 
  return i;
}

/****************************************************************************/

static send_int_16_a( value )
     int value;
{
  send_c_a( value & 0xff );
  send_c_a( (value >> 8) & 0xff );
}

/****************************************************************************/

kbhit()
{
	int i;
	ioctl(0, FIONREAD, &i);
	if (i > 0) return 1;
	else return 0;
}

/****************************************************************************/
