/****************************************************************************/

/* 
plan9.c
Trying to send the pseudo constants for command_c as well. since plan8 worked

plan8.c
Now that we have verified that the local lookup tabel works - we are 
going to try and match that with the global lookup table see if the 
combination works...

plan7.c
This is a copy of plan5.c, not plan6.c.  This version loads a local 
lookup table to the 332.

plan5.c 
This version gets the command signal that is written to the file from the 
332, not the sun's current command.  This should help with the data 
analysis since the sun command was lagging the command being given.

plan4.c
This version loads the constants from sim* from a file (command.info).  
Another data file is written at the end which is also the same as the data 
file written by the data logger.  This way, the same parameter id stuff can be 
used to get parameters off of this data.  The file i called id.dat.
pos vel acc sin(angle) command int(sin) int(command)

plan3.c 

This programs cleans up a lot of the code, assumes that it can always get 
current info from the 332 and attempts to send the command back.  All of 
the info processing is done on the 332 and then it is sent to the sun.

plan1.c
This program reads in the array from command.dat.  Then it issues the 
send packets command to the 332.  Upon receiving an info packet from the 
332, they are processed and the appropriate command is found in the 
command array.  This command is sent to the 332 and the next packet is 
read in and worked on.

The state and time and command-given are also stored in an array and then 
written to a file called data.dat.
time pos vel command 

/****************************************************************************/
/* Include files */

#include <stdio.h>
#include <sgtty.h>
#include <sys/fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/conf.h>
#include <stropts.h>
#include <errno.h>
#include <math.h>

/****************************************************************************/
/****************************************************************************/
/* Constants */

#define TRUE 1
#define FALSE 0
#define N_VARIABLES 4
#define N_POINTS 100
#define N_ID_VARIABLES 7
#define N_CON 18
#define COM_POS_SIZE 3000  /* max command array size */
#define COM_VEL_SIZE 3000
#define COM_POS_SIZE_C 110  /* max command array size */
#define COM_VEL_SIZE_C 110

/* pseudo constants (loaded from a file - command.info) */
int depth;
int N_POS;
int N_VEL;
int UNOCCUPIED;
float START_POS;
float START_VEL;
float GOAL_POS;
float GOAL_VEL;
int COUNTS_PER_REV;
float PI;
int MIN_POS_ENCODER;
int MAX_POS_ENCODER;
int MIN_VEL_ENCODER;
int MAX_VEL_ENCODER;
float DELTA_TIME;
float A;
float B;
float C;

/* pseudo constants (loaded from a file - command_c.info) */
int depth_c;
int N_POS_C;
int N_VEL_C;
int UNOCCUPIED_C;
float START_POS_C;
float START_VEL_C;
float GOAL_POS_C;
float GOAL_VEL_C;
int COUNTS_PER_REV_C;
float PI_C;
int MIN_POS_ENCODER_C;
int MAX_POS_ENCODER_C;
int MIN_VEL_ENCODER_C;
int MAX_VEL_ENCODER_C;
float DELTA_TIME_C;
float A_C;
float B_C;
float C_C;

/* Globals */

int count_a = 0;
int count_b = 0;
int errors_a = 0;
int errors_b = 0;

int packet_id_sent = 0;
char user_input;
int save_info = FALSE;
int time, pos, vel;
/* int command = 0; */
int data_array_index = 0;
float float_time;
int command_332;

/* arrays */

int com_array[COM_POS_SIZE][COM_VEL_SIZE];
int com_array_c[COM_POS_SIZE_C][COM_VEL_SIZE_C];
float data_array[N_POINTS][N_VARIABLES];
float id_data_array[N_POINTS][N_ID_VARIABLES];
/* structures */
    
typedef struct STATE_STRUCT {
        float pos;
        float vel; 
}
STATE;

typedef struct INDICES_STRUCT {
        int pos;   
        int vel;
}
INDICES;

/****************************************************************************/
/****************************************************************************/
load_constants()  {
/* loads the command constants from a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "command.info", "r" ) ) == NULL )  {
	fprintf( stderr, "cannot fopen file command.info for read.\n" );
  }

	fscanf( fd, "%d", &depth );
	printf( "depth: %d\n", depth );
	fscanf( fd, "%d", &N_POS );
	printf( "N_POS: %d\n", N_POS );
	fscanf( fd, "%d ", &N_VEL );
	printf( "N_VEL: %d\n", N_VEL );
	fscanf( fd, "%d ", &UNOCCUPIED );
	printf( "UNOCCUPIED = %d\n", UNOCCUPIED );
	fscanf( fd, "%f ", &START_POS );
	printf( "START_POS: %f\n", START_POS );
	fscanf( fd, "%f ", &START_VEL );
	printf( "START_VEL: %f\n", START_VEL );
	fscanf( fd, "%f ", &GOAL_POS );
	printf( "GOAL_POS: %f\n", GOAL_POS );
	fscanf( fd, "%f ", &GOAL_VEL );
	printf( "GOAL_VEL: %f\n", GOAL_VEL );
	fscanf( fd, "%d ", &COUNTS_PER_REV );
	printf( "COUNTS_PER_REV: %d\n", COUNTS_PER_REV );
	fscanf( fd, "%f ", &PI );
	printf( "PI = %f\n", PI );
	fscanf( fd, "%d ", &MIN_POS_ENCODER );
	printf( "MIN_POS_ENCODER: %d\n", MIN_POS_ENCODER );
	fscanf( fd, "%d ", &MAX_POS_ENCODER );
	printf( "MAX_POS_ENCODER: %d\n", MAX_POS_ENCODER );
	fscanf( fd, "%d ", &MIN_VEL_ENCODER );
	printf( "MIN_VEL_ENCODER: %d\n", MIN_VEL_ENCODER );
	fscanf( fd, "%d ", &MAX_VEL_ENCODER );
	printf( "MAX_VEL_ENCODER: %d\n", MAX_VEL_ENCODER );
	fscanf( fd, "%f ", &DELTA_TIME );
	printf( "DELTA_TIME: %f\n", DELTA_TIME );
	fscanf( fd, "%f ", &A );
	printf( "A = %f\n", A );
	fscanf( fd, "%f ", &B );
	printf( "B = %f\n", B );
	fscanf( fd, "%f ", &C );
	printf( "C = %f\n", C );

  fclose( fd );

}

/****************************************************************************/
/****************************************************************************/
load_constants_c()  {
/* loads the command constants from a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "command_c.info", "r" ) ) == NULL )  {
	fprintf( stderr, "cannot fopen file command_c.info for read.\n" );
  }

	fscanf( fd, "%d", &depth_c );
	printf( "depth_c: %d\n", depth_c );
	fscanf( fd, "%d", &N_POS_C );
	printf( "N_POS_C: %d\n", N_POS_C );
	fscanf( fd, "%d ", &N_VEL_C );
	printf( "N_VEL_C: %d\n", N_VEL_C );
	fscanf( fd, "%d ", &UNOCCUPIED_C );
	printf( "UNOCCUPIED_C = %d\n", UNOCCUPIED_C );
	fscanf( fd, "%f ", &START_POS_C );
	printf( "START_POS_C: %f\n", START_POS_C );
	fscanf( fd, "%f ", &START_VEL_C );
	printf( "START_VEL_C: %f\n", START_VEL_C );
	fscanf( fd, "%f ", &GOAL_POS_C );
	printf( "GOAL_POS_C: %f\n", GOAL_POS_C );
	fscanf( fd, "%f ", &GOAL_VEL_C );
	printf( "GOAL_VEL_C: %f\n", GOAL_VEL_C );
	fscanf( fd, "%d ", &COUNTS_PER_REV_C );
	printf( "COUNTS_PER_REV_C: %d\n", COUNTS_PER_REV_C );
	fscanf( fd, "%f ", &PI_C );
	printf( "PI_C = %f\n", PI_C );
	fscanf( fd, "%d ", &MIN_POS_ENCODER_C );
	printf( "MIN_POS_ENCODER_C: %d\n", MIN_POS_ENCODER_C );
	fscanf( fd, "%d ", &MAX_POS_ENCODER_C );
	printf( "MAX_POS_ENCODER_C: %d\n", MAX_POS_ENCODER_C );
	fscanf( fd, "%d ", &MIN_VEL_ENCODER_C );
	printf( "MIN_VEL_ENCODER_C: %d\n", MIN_VEL_ENCODER_C );
	fscanf( fd, "%d ", &MAX_VEL_ENCODER_C );
	printf( "MAX_VEL_ENCODER_C: %d\n", MAX_VEL_ENCODER_C );
	fscanf( fd, "%f ", &DELTA_TIME_C );
	printf( "DELTA_TIME_C: %f\n", DELTA_TIME_C );
	fscanf( fd, "%f ", &A_C );
	printf( "A_C = %f\n", A_C );
	fscanf( fd, "%f ", &B_C );
	printf( "B_C = %f\n", B_C );
	fscanf( fd, "%f ", &C_C );
	printf( "C_C = %f\n", C_C );

  fclose( fd );

}

/*************************************************************************/
/****************************************************************************/
load_command_array()  {
/* loads the command table from a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "command.dat", "r" ) ) == NULL )  {
	fprintf( stderr, "cannot fopen file command.dat for read.\n" );
  }

  for ( point = 0; point < N_POS ; point++ )  {
	for ( variable = 0; variable < N_VEL ; variable++ )  {
		fscanf( fd, "%d", &com_array[point][variable] );
	}
  }

  fclose( fd );

}

/*************************************************************************/
/****************************************************************************/
load_command_array_c()  {
/* loads the command table from a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "command_c.dat", "r" ) ) == NULL )  {
	fprintf( stderr, "cannot fopen file command_c.dat for read.\n" );
  }

  for ( point = 0; point < N_POS_C ; point++ )  {
	for ( variable = 0; variable < N_VEL_C ; variable++ )  {
		fscanf( fd, "%d", &com_array_c[point][variable] );
	}
  }

  fclose( fd );

}

/*************************************************************************/
/****************************************************************************/
initialize()  {
/* initializes the data array */

  int point, variable;

  for ( point = 0; point < N_POINTS; point++ )  {
	for ( variable = 0; variable < N_VARIABLES; variable++ )  {
		data_array[point][variable] = 0.0;
	}
  }

}

/*************************************************************************/
/****************************************************************************/
print_help()  {

  printf( "\n" );
  printf( "Enter i to initialize the data array.\n" );
  printf( "Enter z to zero the encoders.\n" );
  printf( "Enter p to send a positive command.\n" );
  printf( "Enter n to send a negative command.\n" );
  printf( "Enter q to send a zero command.\n" );
  printf( "Enter r to run pend from the command table and record info.\n" );
  printf( "Enter w to run pend from the command table w/o recording.\n" );
  printf( "Enter e to get the 332 to stop sending data (debug command).\n" );
  printf( "Enter u to upload the local command table to the 332.\n" );
  printf( "Enter x to exit.\n\n" );
  printf( "Simon says > " );
  
}

/****************************************************************************/
/****************************************************************************/
receive_data()  {
/* looks for data from the 332 N_POINTS times */

  int count = 0;
  int point = 0;

  data_array_index = 0;

  for( point = 0; point < N_POINTS ; point++ )  {
	/* actually gets the state of the system */
	process_packet();

	/* a true HACK to solve the serial line clearing problem */
	if ( time == 0 )  {
		point = 0;
		printf( "Zero time reached!\n" );
	}		

	/* give me some feedback every so often if something has gone wrong */
	if ( count >= 10 && errors_a != 0 ) {
		/* printf( "%d: errors: %d\n", point, errors_a ); */
		count = 0;
	}
	else
		count++;

	/* figure out what to do and send command */
	take_action();

	/* stick it in the array */
	store_data( point );

  }

  /* make sure to turn the motor off */
  send_command( 0 );

  /* tell the 332 to stop sending data */
  packet_id_sent = 5; /* tells 332 to stop send data */
  send_packet();

  /* reset error counter */
  errors_a = 0;

  if ( save_info )  {
	printf( "Writing data file.\n" );
	write_data_file(); 
	printf( "Data file data.dat written. \n" );
	printf( "Making the id data file.\n" );
	make_id_data();
	write_id_data_file();
	printf( "Id data file id.dat written.\n" );
  }

}

/*************************************************************************/
/****************************************************************************/
process_packet()  {
/* reads in the packets from the 332 */

  int value;
  int packet_id;

  /* check for handshake */
  while( ( value = read_c_a() ) != 0xff )
    {
      printf( "s1: got error: %d; value: %d %c \n",
	      errors_a, value, value & 0xff );
      errors_a++;
    }

  /* read the packet_id */
  packet_id = read_c_a();
  /* printf( "packet_id: %d\n", packet_id ); */
  /* reads the data */
  time = read_int_32_a();
  float_time = time;
  float_time = float_time / 1000;  /* puts in seconds */
  pos = read_int_32_a();  /* in encoder counts */
  vel = read_int_32_a();  /* in encoder counts per second */
  command_332 = read_int_32_a(); /* 332's motor command */

}

/****************************************************************************/
/****************************************************************************/
send_command( table_command )
	int table_command;
{
/* picks the correct packet_id number to send based on the command */

  switch ( table_command )  {
	case 0:  /* do nothing */
		packet_id_sent = 1;
	break;
	case 1:  /* go negative */
		packet_id_sent = 3;
	break;
	case 2:  /* go positive */
		packet_id_sent = 2;
	break;
	default:  /* do nothing */
		packet_id_sent = 1;
	break;
  }

  send_packet();

}

/****************************************************************************/
/****************************************************************************/
int in_table( indices )
	INDICES indices;
{
/* checks to see if the current state is in the table */

  if ( indices.pos < N_POS && indices.pos > -1 
	&& indices.vel < N_VEL && indices.vel > -1 )
	return( TRUE );
  else
	return( FALSE );

}

/****************************************************************************/
/****************************************************************************/
int get_command( indices )
	INDICES indices;
{
/* looks for the command in the table at the position of the current 
state */

  int table_command;

  table_command = com_array[indices.pos][indices.vel];

  if ( table_command == UNOCCUPIED )  {
	return( 0 );
  }
  else  {
	return( table_command );
  }

}

/****************************************************************************/
/****************************************************************************/
INDICES get_indices ( state )
        STATE state;
{
/* get the indices in the table of the current state (given in encoder 
counts) */

  float pos_encoder, float_pos_index;
  float vel_encoder, float_vel_index;
  INDICES indices;

  pos_encoder = state.pos;
  float_pos_index = ( pos_encoder - MIN_POS_ENCODER ) * N_POS /
        (MAX_POS_ENCODER - MIN_POS_ENCODER);
  /* finds the closest integer */
  indices.pos = ( float_pos_index + .5 ) / 1;

  vel_encoder = state.vel;
  float_vel_index = ( vel_encoder - MIN_VEL_ENCODER ) * N_VEL /
        (MAX_VEL_ENCODER - MIN_VEL_ENCODER);
  /* finds the closest integer */
  indices.vel = ( float_vel_index + .5 ) / 1;

  return( indices );

}

/****************************************************************************/
/****************************************************************************/
take_action()  {

  STATE state;
  INDICES indices;
  int table_command, command;

  state.pos = pos;
  state.vel = vel;
  indices = get_indices( state );

  if ( in_table( indices ) )  {
	command = get_command( indices );
  }
  else  {
	command = 0;
  }

  send_command( command );

}

/*************************************************************************/
/*************************************************************************/
send_packet()  {
/* sends a packet of info to the 332 */

  /* handshake */
  send_c_a( 0xff );
  /* send info (only an id number) */
  send_c_a( packet_id_sent );
  /* printf( "init packet sent.\n" ); */
}

/*************************************************************************/
/*************************************************************************/
send_packet_32()  {
/* sends a packet of info to the 332 */

  /* handshake */
  send_c_a( 0xff );
  /* send info */
  send_int_32_a( packet_id_sent );
  /* printf( "init packet sent.\n" ); */
}

/****************************************************************************/
/****************************************************************************/
store_data( point )  
	int point;
{
/* stores the data in an array */

  if (point < N_POINTS)
    {
      data_array[point][0] = float_time;
      data_array[point][1] = (float) pos;
      data_array[point][2] = (float) vel;
      data_array[point][3] = (float) command_332;
      /* second index should be less than N_VARIABLES */
    }

}

/****************************************************************************/
/****************************************************************************/
float get_radians( encoder )
        float encoder;
{
        
  float radians;
        
  radians = encoder * PI * 2 / COUNTS_PER_REV;
  return( radians ); 
        
}
        
/****************************************************************************/
/****************************************************************************/
make_id_data()  {
/* makes the parameter identification data */

  int point, variable, n_id_points;
  float delta_time, angle_pos, angle_vel, angle_acc;
  float torque_sign, int_sin, int_torque; 

  n_id_points = N_POINTS - 1;
  int_sin = 0;
  int_torque = 0;

  for ( point = 0; point < n_id_points; point++ )  {

        /* get delta time */
        delta_time = data_array[point + 1][0] -
                data_array[point][0];

	/* angle */
	angle_pos = data_array[point][1];  /* in encoder counts */
	angle_pos = get_radians( angle_pos );
	id_data_array[point][0] = angle_pos;

	/* angular velocity */
	angle_vel = data_array[point][2];  /* in encoder counts */
	angle_vel = get_radians( angle_vel );
	id_data_array[point][1] = angle_vel;

	/* angular acceleration */
	angle_acc = (data_array[point + 1][2] 
		- data_array[point][2]) / delta_time;  /* in encoder counts */
	angle_acc = get_radians( angle_acc );
	id_data_array[point][2] = angle_acc;
  
	/* sin ( angle ) */
	id_data_array[point][3] = sin( angle_pos );

	/* command */
	switch( data_array[point][3] )  {
                case 0: /* zero */
                        torque_sign = 0;
                break;
                case 1: /* negative */
                        torque_sign = -1;
                break;
                case 2: /* positive */
                        torque_sign = 1;
                break;
        }
        id_data_array[point][4] = torque_sign;

	/* int ( sin ) */
        int_sin = int_sin + sin( angle_pos ) * delta_time;
        id_data_array[point][5] = int_sin;

	/* int ( command ) */
        int_torque = int_torque + torque_sign * delta_time; 
        id_data_array[point][6] = int_torque;
  }

}

/****************************************************************************/
/****************************************************************************/
write_id_data_file()  {
/* writes the id data in the array to a file */

  FILE *fd;
  int point, variable, n_id_points;

  n_id_points = N_POINTS - 1;

  if ( ( fd = fopen( "id.dat", "w" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file id.dat for write.\n" );
  }
  for ( point = 0; point < n_id_points ; point++ )  {
      for ( variable = 0; variable < N_ID_VARIABLES; variable++ )  {
	  fprintf( fd, "%f ", id_data_array[point][variable] );
      }
      fprintf( fd, "\n" );
  }
  fclose( fd );

}

/****************************************************************************/
/****************************************************************************/
write_data_file()  {
/* writes the data in the array to a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "data.dat", "w" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file data.dat for write.\n" );
  }
  for ( point = 0; point < N_POINTS; point++ )  {
      for ( variable = 0; variable < N_VARIABLES; variable++ )  {
	  fprintf( fd, "%f ", data_array[point][variable] );
      }
      fprintf( fd, "\n" );
  }
  fclose( fd );

}

/****************************************************************************/
/****************************************************************************/
send_table()  {
	
  /* this function sends the local lookup tabel to the 332 */

  int pos_index, vel_index;
  int returned;

  packet_id_sent = N_POS_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "\n" );
  printf( "N_POS_C: %d\n", returned );

  packet_id_sent = N_VEL_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "N_VEL_C: %d\n", returned );

  packet_id_sent = MIN_POS_ENCODER_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "MIN_POS_ENCODER_C: %d\n", returned );

  packet_id_sent = MAX_POS_ENCODER_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "MAX_POS_ENCODER_C: %d\n", returned );

  packet_id_sent = MIN_VEL_ENCODER_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "MIN_VEL_ENCODER_C: %d\n", returned );

  packet_id_sent = MAX_VEL_ENCODER_C;
  send_packet_32();
  returned = read_int_32_a();
  printf( "MAX_VEL_ENCODER_C: %d\n", returned );

  printf( "Press return." );
  getchar();

  for ( pos_index = 0; pos_index < N_POS_C; pos_index++ )  {
	for ( vel_index = 0; vel_index < N_VEL_C; vel_index++ )  {
		packet_id_sent = com_array_c[pos_index][vel_index];
		send_packet();
		returned = read_int_32_a();
		if ( returned < -1 || returned > 2 )
			printf( "pos: %d vel: %d %d\n", pos_index, vel_index, 
				returned );
		else
			printf( "." );
	}
  }

  printf( "\n" );

}

/****************************************************************************/
/****************************************************************************/
main( argc, argv )
int argc;
char *argv[];
{
  init_serial_io( argc, argv );

  printf( "Loading command constants.\n" );
  load_constants(); 
  printf( "Command constants loaded (press return).\n" );
  getchar();

  printf( "Loading capture command constants.\n" );
  load_constants_c(); 
  printf( "Capture command constants loaded (press return).\n" );
  getchar();

  printf( "Loading command array.\n" );
  load_command_array(); 
  printf( "Command array loaded.\n" );

  printf( "Loading capture command array.\n" );
  load_command_array_c(); 
  printf( "Capture command array loaded.\n" );

  while ( 1 )  {

  	print_help();
  	user_input = getchar();
  	switch (user_input)  {
   		case 'i': /* initialize data array */
			initialize();
  		break;
		case 'x':  /* exit the program */
			exit ( 0 );
		break;
		case 'r':  /* use command array to run and save data */
			printf( "\nMake sure zero time is reached!\n" );
			save_info = TRUE;
			packet_id_sent = 4; /* tells the 332 to send data */
			send_packet();
			receive_data();  /* receive, process, command */
		break;
		case 'z':  /* zero the encoders */
			packet_id_sent = 6;
			send_packet();
		break;
		case 'w':  /* run w/o collecting data */
			save_info = FALSE;
			packet_id_sent = 4; /* tells the 332 to send data */
			send_packet();
			receive_data();  /* receive, process, command */
		break;
		case 'e':  /* tells the 332 to stop sending data */
			packet_id_sent = 5; /* tells 332 to stop send data */
                        send_packet();
		break;
		case 'p':  /* send positive command */
			packet_id_sent = 2;  /* positive packet id */
			send_packet();
		break;
		case 'n':  /* send negative command */
			packet_id_sent = 3;  /* negative packet id */
			send_packet();
		break;
		case 'q':  /* send zero command */
			packet_id_sent = 1;  /* zero packet id */
			send_packet();
		break;
		case 'u':  /* upload local command table */
			packet_id_sent = 7;
			send_packet();
			printf( "Sending local command table.\n" );
			send_table();
			printf( "Local command table sent.\n" );
		break;
		}
  }			

}

/*************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/* STUFF FOR SERIAL PORT */
/*************************************************************************/

#define BUFFSIZE (FMNAMESZ+1)

char buff_a[BUFFSIZE];
char buff_b[BUFFSIZE];

char *ProgName;

struct sgttyb	osavrem_a,	/* original remote tty state */
		nsavrem_a;	/* new remote tty state */
struct sgttyb	osavrem_b,	/* original remote tty state */
		nsavrem_b;	/* new remote tty state */

int rem_a;
int rem_b;

char *remdev_a = "/dev/ttya";
char *remdev_b = "/dev/ttyb";

char strip_parity = 0xff;

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

init_serial_io(argc, argv)
int argc;
char *argv[];
{
  int status;

  /* char sgspeed = B9600; */
  /* char sgspeed = B19200; */
  char sgspeed = B38400;

  if ((rem_a = open(remdev_a, O_RDWR /*|| O_NDELAY*/)) < 0)
    {
      fprintf(stderr,"Can't open tty line %s!\n",remdev_a);
      perror("open");
      exit(1);
    }
  if ((rem_b = open(remdev_b, O_RDWR /*|| O_NDELAY*/)) < 0)
    {
      fprintf(stderr,"Can't open tty line %s!\n",remdev_b);
      perror("open");
      exit(1);
    }

  ioctl(rem_a, TIOCGETP, &osavrem_a);
  ioctl(rem_b, TIOCGETP, &osavrem_b);

  nsavrem_a = osavrem_a;
  nsavrem_b = osavrem_b;

  if(sgspeed)
    {
      nsavrem_a.sg_ispeed = sgspeed;
      nsavrem_a.sg_ospeed = sgspeed;
      nsavrem_b.sg_ispeed = sgspeed;
      nsavrem_b.sg_ospeed = sgspeed;
    }

  nsavrem_a.sg_flags &= ~ECHO; 
  nsavrem_a.sg_flags |= RAW|TANDEM;
  nsavrem_b.sg_flags &= ~ECHO; 
  nsavrem_b.sg_flags |= RAW|TANDEM;

  ioctl(rem_a, TIOCSETP, &nsavrem_a);
  ioctl(rem_a, TIOCEXCL, NULL);
  ioctl(rem_a, TIOCHPCL, NULL); 
  ioctl(rem_b, TIOCSETP, &nsavrem_b);
  ioctl(rem_b, TIOCEXCL, NULL);
  ioctl(rem_b, TIOCHPCL, NULL); 
  fcntl(rem_a, F_SETFL, O_SYNC);
  fcntl(rem_a, F_SETFL, FNDELAY);
  fcntl(rem_b, F_SETFL, O_SYNC);
  fcntl(rem_b, F_SETFL, FNDELAY);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

/* no hang version */
read_c_a_no_hang()
{
  int value, bytes_read;
  int i;

  bytes_read = read(rem_a, buff_a, 1);
  if ( bytes_read > 0 )
    {
      value = buff_a[0] & 0xff;
      return value;
    }
  else
    return -1;
}

/*************************************************************************/

/*************************************************************************/

/* no hang version */
read_c_b_no_hang()
{
  int value, bytes_read;
  int i;

  bytes_read = read(rem_b, buff_b, 1);
  if ( bytes_read > 0 )
    {
      value = buff_b[0] & 0xff;
      return value;
    }
  else
    return -1;
}

/*************************************************************************/

read_c_a()
{
  int value, bytes_read;
  int i;

  bytes_read = 0;
  while (bytes_read <= 0)
    {
      bytes_read = read(rem_a, buff_a, 1);
    }
  value = buff_a[0] & 0xff;
  return value;
}

/*************************************************************************/

read_c_b()
{
  int value, bytes_read;
  int i;

  bytes_read = 0;
  while (bytes_read <= 0)
    {
      bytes_read = read(rem_b, buff_b, 1);
    }
  value = buff_b[0] & 0xff;
  return value;
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/

send_c_a( c )
     int c;
{
  int i;

  buff_a[ 0 ] = c & 0xff;
  write(rem_a, buff_a, 1);
}

/*************************************************************************/

send_c_b( c )
     int c;
{
  buff_b[ 0 ] = c & 0xff;
  write(rem_b, buff_b, 1);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/


finish()
{
  exit(0);
  ioctl(rem_a, TIOCSETP, &osavrem_a);
  ioctl(rem_a, TIOCNXCL, NULL);
  ioctl(rem_b, TIOCSETP, &osavrem_b);
  ioctl(rem_b, TIOCNXCL, NULL);
}

/*************************************************************************/
/****************************************************************************/

static read_int_16_a()
{
  int i;
  
  i = 0;
  i += read_c_a();
  i += read_c_a() << 8; 
  if ( i & 0x8000 )
    i |= 0xffff0000;
  return i;
}

/****************************************************************************/

static read_int_32_a()
{
  int i;
  
  i = 0;
  i += read_c_a();
  i += read_c_a() << 8; 
  i += read_c_a() << 16; 
  i += read_c_a() << 24; 
  return i;
}

/****************************************************************************/

static send_int_16_a( value )
     int value;
{
  send_c_a( value & 0xff );
  send_c_a( (value >> 8) & 0xff );
}

/****************************************************************************/

static send_int_32_a( value )
     int value;
{
  send_c_a( value & 0xff );
  value >>= 8;
  send_c_a( value & 0xff );
  value >>= 8;
  send_c_a( value & 0xff );
  value >>= 8;
  send_c_a( value & 0xff );
}

/****************************************************************************/

kbhit()
{
	int i;
	ioctl(0, FIONREAD, &i);
	if (i > 0) return 1;
	else return 0;
}

/****************************************************************************/
