/****************************************************************************/

/* 

act2.c
Automatically loads file parameters...

This two arm version simulates the acrobot in the same way as the pendulum.

This program simulates the pendulum and uses the lookup tabel created by 
the sim program to see if the goal state can be reached.

The command.dat file must be in this directory and the constants for the two 
programs must be the same for it to work. (Except DELTA_TIME which should be 
positive.)

  */

/****************************************************************************/
/* Include files */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>

/****************************************************************************/
/****************************************************************************/
/* Constants */

#define TRUE 1
#define FALSE 0
#define COM_POS_1_SIZE 50  /* max command array size */
#define COM_VEL_1_SIZE 50
#define COM_POS_2_SIZE 50
#define COM_VEL_2_SIZE 50        
/*
#define N_POS_1 500
#define N_VEL_1 500
#define N_POS_2 500
#define N_VEL_2 500
#define UNOCCUPIED -1
#define START_POS_1 0.00
#define START_VEL_1 0.00
#define START_POS_2 0.00
#define START_VEL_2 0.00
#define GOAL_POS_1 3.1415
#define GOAL_VEL_1 0.00
#define GOAL_POS_2 3.1415
#define GOAL_VEL_2 0.00
#define COUNTS_PER_REV 2000
#define PI 3.1416
#define MIN_POS_ENCODER_1 -1500
#define MAX_POS_ENCODER_1 1500
#define MIN_VEL_ENCODER_1 -9000
#define MAX_VEL_ENCODER_1 9000
#define MIN_POS_ENCODER_2 -1500
#define MAX_POS_ENCODER_2 1500
#define MIN_VEL_ENCODER_2 -9000
#define MAX_VEL_ENCODER_2 9000
#define DELTA_TIME .010
#define A 15.36
#define B -66.12
#define C -0.5
#define D -0.5
#define E -0.5
#define F -0.5
#define FILE_SAVE_INTERVAL 5000
*/
/* Global vars */

/* pseudo constants (loaded from a file - command.info) */
int depth;
int N_POS_1;
int N_VEL_1;
int N_POS_2;
int N_VEL_2;
int UNOCCUPIED;
float START_POS_1;
float START_VEL_1;
float START_POS_2;
float START_VEL_2;
float GOAL_POS_1;
float GOAL_VEL_1;
float GOAL_POS_2;
float GOAL_VEL_2;
int COUNTS_PER_REV;
float PI;
int MIN_POS_ENCODER_1;
int MAX_POS_ENCODER_1;
int MIN_VEL_ENCODER_1;
int MAX_VEL_ENCODER_1;
int MIN_POS_ENCODER_2;
int MAX_POS_ENCODER_2;
int MIN_VEL_ENCODER_2;
int MAX_VEL_ENCODER_2;
float DELTA_TIME;
float A;
float B;
float C;
float D;                           
float E;
float F;
          
/* arrays */
int com_array[COM_POS_1_SIZE][COM_VEL_1_SIZE][COM_POS_2_SIZE][COM_VEL_2_SIZE];

/* structures */

typedef struct STATE_STRUCT {
	float pos_1;
	float vel_1;
	float pos_2;
	float vel_2;
}
STATE;

typedef struct INDICES_STRUCT {
	int pos_1;
	int vel_1;
	int pos_2;
	int vel_2;
} 
INDICES; 


/* data structures and definitions for the queue */

typedef struct QUEUE_NODE_STRUCT {
	STATE data;
	int command;
	struct QUEUE_NODE_STRUCT *next;
}
QUEUE_NODE; 

/* global b/c I have no freakin clue how to do it otherwise */
QUEUE_NODE *free_queue;
/* This is fine. CGA */
/* Thanks.  -Sean */

/****************************************************************************/
/****************************************************************************/
load_constants()  {
/* loads the command constants from a file */

  FILE *fd;
  int point, variable;

  if ( ( fd = fopen( "command.info", "r" ) ) == NULL )  {
        fprintf( stderr, "cannot fopen file command.info for read.\n" );
  }

        fscanf( fd, "%d", &depth );
        printf( "depth: %d\n", depth );
        fscanf( fd, "%d", &N_POS_1 );
        printf( "N_POS_1: %d\n", N_POS_1 );
        fscanf( fd, "%d ", &N_VEL_1 );
        printf( "N_VEL_1: %d\n", N_VEL_1 );
        fscanf( fd, "%d", &N_POS_2 );
        printf( "N_POS_2: %d\n", N_POS_2 );
        fscanf( fd, "%d ", &N_VEL_2 );
        printf( "N_VEL_2: %d\n", N_VEL_2 );
        fscanf( fd, "%d ", &UNOCCUPIED );
        printf( "UNOCCUPIED = %d\n", UNOCCUPIED );
        fscanf( fd, "%f ", &START_POS_1 );
        printf( "START_POS_1: %f\n", START_POS_1 );
        fscanf( fd, "%f ", &START_VEL_1 );
        printf( "START_VEL_1: %f\n", START_VEL_1 );
        fscanf( fd, "%f ", &GOAL_POS_1 );
        printf( "GOAL_POS_1: %f\n", GOAL_POS_1 );
        fscanf( fd, "%f ", &GOAL_VEL_1 );
        printf( "GOAL_VEL_1: %f\n", GOAL_VEL_1 );
        fscanf( fd, "%f ", &START_POS_2 );
        printf( "START_POS_2: %f\n", START_POS_2 );
        fscanf( fd, "%f ", &START_VEL_2 );
        printf( "START_VEL_2: %f\n", START_VEL_2 );
        fscanf( fd, "%f ", &GOAL_POS_2 );            
        printf( "GOAL_POS_2: %f\n", GOAL_POS_2 );
        fscanf( fd, "%f ", &GOAL_VEL_2 );
        printf( "GOAL_VEL_2: %f\n", GOAL_VEL_2 );
        fscanf( fd, "%d ", &COUNTS_PER_REV );
        printf( "COUNTS_PER_REV: %d\n", COUNTS_PER_REV );
        fscanf( fd, "%f ", &PI );
        printf( "PI = %f\n", PI );
        fscanf( fd, "%d ", &MIN_POS_ENCODER_1 );
        printf( "MIN_POS_ENCODER_1: %d\n", MIN_POS_ENCODER_1 );
        fscanf( fd, "%d ", &MAX_POS_ENCODER_1 );
        printf( "MAX_POS_ENCODER_1: %d\n", MAX_POS_ENCODER_1 );
        fscanf( fd, "%d ", &MIN_VEL_ENCODER_1 );
        printf( "MIN_VEL_ENCODER_1: %d\n", MIN_VEL_ENCODER_1 );
        fscanf( fd, "%d ", &MAX_VEL_ENCODER_1 );
        printf( "MAX_VEL_ENCODER_1: %d\n", MAX_VEL_ENCODER_1 );
        fscanf( fd, "%d ", &MIN_POS_ENCODER_2 );
        printf( "MIN_POS_ENCODER_2: %d\n", MIN_POS_ENCODER_2 );
        fscanf( fd, "%d ", &MAX_POS_ENCODER_2 );
        printf( "MAX_POS_ENCODER_2: %d\n", MAX_POS_ENCODER_2 );
        fscanf( fd, "%d ", &MIN_VEL_ENCODER_2 );
        printf( "MIN_VEL_ENCODER_2: %d\n", MIN_VEL_ENCODER_2 );
        fscanf( fd, "%d ", &MAX_VEL_ENCODER_2 );
        printf( "MAX_VEL_ENCODER_2: %d\n", MAX_VEL_ENCODER_2 );
        fscanf( fd, "%f ", &DELTA_TIME );
        printf( "DELTA_TIME: %f\n", DELTA_TIME );
        fscanf( fd, "%f ", &A );
        printf( "A = %f\n", A );
        fscanf( fd, "%f ", &B );
        printf( "B = %f\n", B );
        fscanf( fd, "%f ", &C );
        printf( "C = %f\n", C );
        fscanf( fd, "%f ", &D );
        printf( "D = %f\n", D );
        fscanf( fd, "%f ", &E );
        printf( "E = %f\n", E );
        fscanf( fd, "%f ", &F );
        printf( "F = %f\n", F );

  fclose( fd );                   

}

/****************************************************************************/
/****************************************************************************/
QUEUE_NODE * add_to_top( queue, state )
  QUEUE_NODE *queue;
  STATE state;
{
  QUEUE_NODE *new_queue;

  /* allocate memory */
  new_queue = ( QUEUE_NODE * ) malloc( sizeof( QUEUE_NODE ) );
  if ( new_queue == NULL )  {
	printf ( "Memory allocation error" );                
	exit(-1);
  }                      

  new_queue->data = state;
  new_queue->command = 0;
  new_queue->next = queue;

  return( new_queue ); 

}
/****************************************************************************/
/****************************************************************************/
QUEUE_NODE * pop_off_top( queue )
	QUEUE_NODE *queue;
{
  QUEUE_NODE *temp;

/* pops off the top of the queue and adds to the free_queue */

  if ( queue != NULL ) { 
	temp = free_queue;
	free_queue = queue;
	queue = queue->next;
	free_queue->next = temp;
  }
  else  {
  }

  return( queue );

}
/****************************************************************************/
/****************************************************************************/
QUEUE_NODE * add_to_end( queue, state, command )
	QUEUE_NODE *queue;
	STATE state;
	int command;
{

/* adds a node to the end of the queue by taking it from the free_queue 
if available or allocating space otherwise */

  if ( queue != NULL )  {
	queue->next = add_to_end( queue->next, state, command );
  }
  else  {
	/* allocate memory */
	queue = ( QUEUE_NODE * ) malloc( sizeof( QUEUE_NODE ) );
	if ( queue == NULL )  {
		printf ( "Memory allocation error" );                
		exit(-1);
	}
	queue->data = state;
	queue->command = command;
	queue->next = NULL;
  }	

  return ( queue );

}	

/****************************************************************************/
/****************************************************************************/
STATE get_top_data( queue )
        QUEUE_NODE *queue;
{
  if ( queue != NULL )  {
	return( queue->data );
  }
  else  {
	printf( "queue is empty.\n" );
	exit ( -1 );
  }	

}                   
                   
/****************************************************************************/
/****************************************************************************/
init_array()  {

  int index1, index2, index3, index4;

  for ( index1 = 0 ; index1 < N_POS_1 ; index1++ )  {
	for (index2 = 0 ; index2 < N_VEL_1 ; index2++ )  {
		for ( index3 = 0 ; index3 < N_POS_2 ; index3++ )  {
			for (index4 = 0 ; index4 < N_VEL_2 ; index4++ )  {
				com_array[index1][index2][index3][index4] 
					= UNOCCUPIED;
			}
		}
	}
  }

}

/****************************************************************************/
/****************************************************************************/
STATE get_start()  {

  STATE temp_state;

  temp_state.pos_1 = START_POS_1;
  temp_state.vel_1 = START_VEL_1;
  temp_state.pos_2 = START_POS_2;
  temp_state.vel_2 = START_VEL_2;

  return( temp_state );

}

/****************************************************************************/
/****************************************************************************/
INDICES get_indices ( state )
	STATE state;
{
         
  float pos_encoder, float_pos_index;
  float vel_encoder, float_vel_index;
  INDICES indices;

  pos_encoder = state.pos_1 * COUNTS_PER_REV / 2 / PI;
  float_pos_index = ( pos_encoder - MIN_POS_ENCODER_1 ) * N_POS_1 /
        (MAX_POS_ENCODER_1 - MIN_POS_ENCODER_1);
  /* finds the closest integer */
  indices.pos_1 = ( float_pos_index + .5 ) / 1;

  vel_encoder = state.vel_1 * COUNTS_PER_REV / 2 / PI;
  float_vel_index = ( vel_encoder - MIN_VEL_ENCODER_1 ) * N_VEL_1 /
        (MAX_VEL_ENCODER_1 - MIN_VEL_ENCODER_1);
  /* finds the closest integer */
  indices.vel_1 = ( float_vel_index + .5 ) / 1;
  
  pos_encoder = state.pos_2 * COUNTS_PER_REV / 2 / PI;
  float_pos_index = ( pos_encoder - MIN_POS_ENCODER_2 ) * N_POS_2 /
        (MAX_POS_ENCODER_2 - MIN_POS_ENCODER_2);
  /* finds the closest integer */
  indices.pos_2 = ( float_pos_index + .5 ) / 1;

  vel_encoder = state.vel_2 * COUNTS_PER_REV / 2 / PI;
  float_vel_index = ( vel_encoder - MIN_VEL_ENCODER_2 ) * N_VEL_2 /
        (MAX_VEL_ENCODER_2 - MIN_VEL_ENCODER_2);
  /* finds the closest integer */
  indices.vel_2 = ( float_vel_index + .5 ) / 1;
  
  return( indices );
  
}

/****************************************************************************/
/****************************************************************************/
int in_table( indices )
	INDICES indices;
{
        
  if ( indices.pos_1 > -1 && indices.pos_1 < N_POS_1
        && indices.vel_1 > -1 && indices.vel_1 < N_VEL_1
        && indices.pos_2 > -1 && indices.pos_2 < N_POS_2
        && indices.vel_2 > -1 && indices.vel_2 < N_VEL_2 ) {
        return( TRUE );
  }
  else  {
        return( FALSE );
  }
  
}
        
/****************************************************************************/
/****************************************************************************/
STATE get_goal()  {

  STATE temp_state;
 
  temp_state.pos_1 = GOAL_POS_1;
  temp_state.vel_1 = GOAL_VEL_1;
  temp_state.pos_2 = GOAL_POS_2;
  temp_state.vel_2 = GOAL_VEL_2;
        
  return( temp_state );

}  

/****************************************************************************/
/****************************************************************************/
STATE get_next_state( current_state, command )
        STATE current_state;
        int command;
{

/* equations are from Sutton 98 */

  /* parameters */
  float m1 = .232; /* mass link 1 (kg) */
  float m2 = .132; /* mass link 2 (kg) */
  float l1 = .2397; /* length link 1 (m) */
  float l2 = .2397; /* length link 2 (m) */
  float lc1 = .1199; /* axis to center of mass link 1 (m) */
  float lc2 = .0719; /* axis to center of mass link 2 (m) */
  float i1 = .006867; /* moment of inertia link 1 (kgm^2) */
  float i2 = .001162; /* moment of inertia link 2 (kgm^2) */
  float g = 9.81; /* gravity (m/s^2) */

  /* variables */
  float torque_sign = 0;
  float accel_1 = 0;
  float accel_2 = 0;
  float d1 = 0;
  float d2 = 0;
  float phi1 = 0;
  float phi2 = 0;
  float pos_1 = 0;
  float pos_2 = 0;
  float vel_1 = 0;
  float vel_2 = 0;
  STATE previous_state;

  /* conversion for command */
  /* 0 = zero torque sent */                                 
  /* 1 = negative torque sent */
  /* 2 = positive torque sent */
  switch( command )  {
        case 0:
                torque_sign = 0.00;
        break;
        case 1:
                torque_sign = -1.00;
        break;
        case 2:
                torque_sign = 1.00;
        break;
  }

  /* change variables to make it easier */
  pos_1 = current_state.pos_1;
  pos_2 = current_state.pos_2;
  vel_1 = current_state.vel_1;
  vel_2 = current_state.vel_2;

  /* change sign on DELTA_TIME */
  DELTA_TIME = - DELTA_TIME;

  /* Calculate the state - notice it is previous since DELTA_TIME is  0 */
  phi2 = m2 * lc2 * g * cos( pos_1 + pos_2
        - PI / 2 );
  phi1 = - m2 * l1 * lc2 * pow( vel_2, 2 ) * sin( pos_2 )
        - 2 * m2 * l1 * lc2 * vel_2 * vel_1 * sin( pos_2 )
        + ( m1 * lc1 + m2 * l1 ) * g * cos( pos_1 - PI/2 ) + phi2;
  d2 = m2 * ( pow( lc2, 2 ) + l1 * l2 * cos( pos_2 ) ) + i2;
  d1 = m1 * pow( lc1, 2 )
        + m2 * ( pow( l1, 2 ) + pow( lc2, 2 ) + 2 * l1 * lc2 * cos( pos_2 
) )
        + i1 + i2;
  accel_2 = 1 / ( m2 * pow( lc2, 2 ) + i2 - pow( d2, 2 ) / d1 )
        * ( torque_sign + d2 / d1 * phi1 - phi2 );
  accel_1 = - 1 / d1 * ( d2 * accel_2 + phi1 );

  /* get new state */
  previous_state.vel_1 = current_state.vel_1 + DELTA_TIME * accel_1;
  previous_state.pos_1 = current_state.pos_1 + DELTA_TIME
        * current_state.vel_1                                     
        + .5 * accel_1 * DELTA_TIME * DELTA_TIME;

  previous_state.vel_2 = current_state.vel_2 + DELTA_TIME * accel_2;
  previous_state.pos_2 = current_state.pos_2 + DELTA_TIME
        * current_state.vel_2
        + .5 * accel_2 * DELTA_TIME * DELTA_TIME;

  return( previous_state );

}
                                           
/****************************************************************************/
/****************************************************************************/
int same_indices( indices1, indices2 )
	INDICES indices1;
	INDICES indices2;
{
  
  if ( ( indices1.pos_1 == indices2.pos_1 )
        && ( indices1.vel_1 == indices2.vel_1 )
        && ( indices1.pos_2 == indices2.pos_2 )
        && ( indices1.vel_2 == indices2.vel_2 ) )  {
        return( TRUE );
  }
  else  {
        return( FALSE );
  }
  
}
 
/****************************************************************************/
/****************************************************************************/
int cell_unoccupied( indices )
	INDICES indices;
{
        
  if ( com_array[indices.pos_1][indices.vel_1][indices.pos_2][indices.vel_2]
        == UNOCCUPIED )  {
        return( TRUE );
  }
  else  {
        return( FALSE );
  }
        
}               
  
/****************************************************************************/
/****************************************************************************/
mark_table( indices, command )
	INDICES indices;
	int command;
{
  
  com_array[indices.pos_1][indices.vel_1][indices.pos_2][indices.vel_2]
        = command;

}

/****************************************************************************/
/****************************************************************************/
int get_command( indices, command )
	INDICES indices;
	int command;
{

  command = 
	com_array[indices.pos_1][indices.vel_1][indices.pos_2][indices.vel_2];

  return( command );

}

/****************************************************************************/
/****************************************************************************/
int cell_occupied( indices )
	INDICES indices;
{
        
  if ( com_array[indices.pos_1][indices.vel_1][indices.pos_2][indices.vel_2]
        != UNOCCUPIED )  {
        return( TRUE ); 
  }
  else  {
        return( FALSE );
  }

}

/****************************************************************************/
/****************************************************************************/
write_queue_to_file( queue ) 
	QUEUE_NODE *queue;
{

  FILE *fd;
  QUEUE_NODE *temp;

  if ( ( fd = fopen( "traj.dat", "w" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file traj.dat for write.\n" );
  }

  temp = queue;

  while ( temp != NULL )  {
        fprintf( fd, "%f ", temp->data.pos_1 );
        fprintf( fd, "%f ", temp->data.vel_1 );
        fprintf( fd, "%f ", temp->data.pos_2 );
        fprintf( fd, "%f ", temp->data.vel_2 );
        fprintf( fd, "%d ", temp->command );
        fprintf( fd, "\n" );
	temp = temp->next;
  }

  fclose( fd );

}                 

/****************************************************************************/
/****************************************************************************/
load_command_array() {

  FILE *fd;
  int index1, index2, index3, index4;

  if ( ( fd = fopen( "command.dat", "r" ) ) == NULL )  {
      fprintf( stderr, "cannot fopen file command.dat for reading.\n" );
      exit( -1 );
  }

  for ( index1 = 0 ; index1 < N_POS_1 ; index1++ )  {
        for ( index2 = 0 ; index2 < N_VEL_1 ; index2++ )  {
		for ( index3 = 0 ; index3 < N_POS_2 ; index3++ )  {
        		for ( index4 = 0 ; index4 < N_VEL_2 ; index4++ )  {
                		fscanf( fd, "%d ", 
				  &com_array[index1][index2][index3][index4] );
			}
		}
        }
  }

  fclose( fd );

}                 

/****************************************************************************/
/****************************************************************************/
print_queue( queue )
	QUEUE_NODE *queue;
{
  
  if ( queue != NULL )  {
        printf( "pos_1: %f vel_1: %f\n", queue->data.pos_1, 
                queue->data.vel_1 );
        printf( "pos_2: %f vel_2: %f\n", queue->data.pos_2, 
                queue->data.vel_2 );
        print_queue( queue->next );
  }
  
}
  
/****************************************************************************/
/****************************************************************************/
print_state( state )
	STATE state;
{
  
        printf( "pos_1: %f vel_1: %f\n", state.pos_1, state.vel_1 );
        printf( "pos_2: %f vel_2: %f\n", state.pos_2, state.vel_2 );
  
}

/****************************************************************************/
/****************************************************************************/
print_indices( indices )
	INDICES indices;
{
        
        printf( "pos_1: %d vel_1: %d\n", indices.pos_1, indices.vel_1 );
        printf( "pos_2: %d vel_2: %d\n", indices.pos_2, indices.vel_2 );

}

/****************************************************************************/
/****************************************************************************/
print_table_command( indices )
	INDICES indices;
{

        printf( "table command: %d\n",
        com_array[indices.pos_1][indices.vel_1][indices.pos_2][indices.vel_2]
        );
        
}

/****************************************************************************/
/****************************************************************************/
init_free_queue()  {

  free_queue = NULL;
 
  /* allocate memory for free_queue */
  free_queue = ( QUEUE_NODE * ) malloc( sizeof( QUEUE_NODE ) );
  if ( free_queue == NULL )  {
	printf ( "Memory allocation error" );                
	exit(-1);
  }                      

  free_queue->next = NULL;

}

/****************************************************************************/
/****************************************************************************/
INDICES get_in_table( indices )
        INDICES indices;
{
/* rolls position over to the other side of the table */

  if ( indices.pos_1 < MIN_POS_ENCODER_1 )
        indices.pos_1 = indices.pos_1 + MAX_POS_ENCODER_1 - MIN_POS_ENCODER_1;
  if ( indices.pos_1 > MAX_POS_ENCODER_1 )
        indices.pos_1 = indices.pos_1 - MAX_POS_ENCODER_1 + MIN_POS_ENCODER_1;
/*
  if ( indices.vel_1 < MIN_VEL_ENCODER_1 )
        indices.vel_1 = indices.vel_1 + MAX_VEL_ENCODER_1 - MIN_VEL_ENCODER_1;
  if ( indices.vel_1 > MAX_VEL_ENCODER_1 )
        indices.vel_1 = indices.vel_1 - MAX_VEL_ENCODER_1 + MIN_VEL_ENCODER_1;
*/
  if ( indices.pos_2 < MIN_POS_ENCODER_2 )
        indices.pos_2 = indices.pos_2 + MAX_POS_ENCODER_2 - MIN_POS_ENCODER_2;
  if ( indices.pos_2 > MAX_POS_ENCODER_2 )
        indices.pos_2 = indices.pos_2 - MAX_POS_ENCODER_2 + MIN_POS_ENCODER_2;
/*
  if ( indices.vel_2 < MIN_VEL_ENCODER_2 )
        indices.vel_2 = indices.vel_2 + MAX_VEL_ENCODER_2 - MIN_VEL_ENCODER_2;
  if ( indices.vel_2 > MAX_VEL_ENCODER_2 )
        indices.vel_2 = indices.vel_2 - MAX_VEL_ENCODER_2 + MIN_VEL_ENCODER_2;
*/                                                                    
  return( indices );

}
       

/****************************************************************************/
/****************************************************************************/

main( argc, argv )
int argc;
char *argv[];
{
  QUEUE_NODE *queue;
  STATE start_state;
  STATE goal_state;
  STATE current_state;
  STATE next_state;
  INDICES start_indices;
  INDICES goal_indices;
  INDICES current_indices;
  int time_steps;
  int goal_not_reached;
  int not_too_long;
  int max_time_steps;
  int command;

  /* init stuff */
  time_steps = 0;
  goal_not_reached = TRUE;
  not_too_long = TRUE;
  queue = NULL;

  /* load the command_array */
  printf( "Loading the command constants.\n" );
  load_constants();
  printf( "Loading command array.\n" );
  load_command_array();

  /* get max queue depth = number of nodes visited and expanded */
  printf( "Enter the max time steps.\n" );
  scanf( "%d", &max_time_steps );

  /* define start */
  start_state = get_start();
  start_indices = get_indices( start_state );
  if ( in_table( start_indices ) )  {
	current_state = start_state;
  }
  else  {
	printf( "Start not in table!!!\n" );
	exit( -1 );
  }

  /* define goal */
  goal_state = get_goal();
  goal_indices = get_indices( goal_state );
  if ( in_table( goal_indices ) )  {
	/* do nothing */
  }
  else  {
	printf( "Goal not in table!!!\n" );
	exit( -1 );
  }

  /* do the cool stuff - ie twitch the lil sucker */
  while ( goal_not_reached && not_too_long )  {
	current_indices = get_indices( current_state );
	current_indices = get_in_table( current_indices ); /* corrects position */
	if ( in_table( current_indices ) != TRUE )  {
		printf( "It's gone off the table.\n" );
		write_queue_to_file( queue );
		exit( -1 );  /* die a horrible death */
	}
	command = get_command( current_indices );
	next_state = get_next_state( current_state, command );
/*
	print_state( current_state );
	printf( "Command: %d\n", command );
	print_state( next_state );
*/
	queue = add_to_end( queue, current_state, command );
	time_steps++;

	if ( time_steps%100 == 0 )  {
		printf( "Time steps: %d\n", time_steps );
	}

	/* get ready for next go around */
	current_state = next_state;

	if ( time_steps > max_time_steps )  {
		printf( "Timed out.\n" );
		not_too_long = FALSE;
	}

	if ( current_state.pos_1 == goal_state.pos_1
		&& current_state.vel_1 == goal_state.vel_1
		&& current_state.pos_2 == goal_state.pos_2
		&& current_state.vel_2 == goal_state.vel_2 )  {
		printf( "Goal reached.\n" );
		goal_not_reached = FALSE;
	}

  }

  write_queue_to_file( queue );

  return( 0 );

}

/*************************************************************************/
/****************************************************************************/


