#ifndef __SUFSORT_H__
#define __SUFSORT_H__


#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"


/* -------------------------------------------------------------------------- */
/* type of structures                                                         */

// bucket info
typedef struct _bucket_t
{
    // number of elements of bucket
    INDEX_TYPE_T freqs[NUM_SLOTS];
    // starting postion of bucket
    INDEX_TYPE_T offs[NUM_SLOTS];
} bucket_t;


/* -------------------------------------------------------------------------- */
/* definition of functions                                                    */

// precompute a value for each 3 consecutive symbols
void transform_to_triplet (char *reads, int read_len, INDEX_TYPE_T num_reads);

// precomputation for reverse reads
void transform_to_triplet_reverse (char *reads, int read_len,
                                   INDEX_TYPE_T num_reads);
// sort by the first 3 characters
void initial_sort (char *reads, INDEX_TYPE_T num_elems, bucket_t * bkt,
                   INDEX_TYPE_T * bsize, INDEX_TYPE_T * boffset,
                   INDEX_TYPE_T * max_size);

// sort one of the buckets generated by initial_sort()
void suf_sort (INDEX_TYPE_T * sa, char *reads, int slot,
               INDEX_TYPE_T * new_idx, bucket_t * bkt0,
               INDEX_TYPE_T num_elems, int read_len,
               INDEX_TYPE_T * interval_start, INDEX_TYPE_T * interval_end,
               u16 * interval_depth, omp_lock_t * read_lock,
               INDEX_TYPE_T bkt_offset, int min_overlap);


#endif /* __SUFSORT_H__ */
