VERSION 5.00
Object = "{9A06A082-180E-11D2-80AF-00A0C9044B04}#1.0#0"; "PLMon32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5895
   ClientLeft      =   60
   ClientTop       =   300
   ClientWidth     =   8670
   LinkTopic       =   "Form1"
   ScaleHeight     =   5895
   ScaleWidth      =   8670
   StartUpPosition =   3  'Windows Default
   Begin PLMon32.PLMon PLMon1 
      Left            =   2760
      Top             =   3480
      _ExtentX        =   873
      _ExtentY        =   609
   End
   Begin VB.TextBox APDUHeader 
      Height          =   285
      Left            =   3360
      TabIndex        =   20
      Text            =   "00"
      Top             =   840
      Width           =   375
   End
   Begin VB.TextBox NPDUService 
      Height          =   285
      Left            =   1560
      TabIndex        =   18
      Text            =   "50"
      Top             =   840
      Width           =   375
   End
   Begin VB.ListBox Results 
      Height          =   5130
      Left            =   5400
      TabIndex        =   15
      Top             =   360
      Width           =   3015
   End
   Begin VB.TextBox Npdu 
      Height          =   285
      Left            =   600
      TabIndex        =   14
      Top             =   1200
      Width           =   4455
   End
   Begin VB.TextBox DestUnit 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   1440
      TabIndex        =   12
      Text            =   "0009"
      Top             =   2400
      Width           =   615
   End
   Begin VB.TextBox DestHouse 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   720
      TabIndex        =   11
      Text            =   "0001"
      Top             =   2400
      Width           =   615
   End
   Begin VB.TextBox SourceUnit 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   1440
      TabIndex        =   10
      Text            =   "0001"
      Top             =   2040
      Width           =   615
   End
   Begin VB.TextBox SourceHouse 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   720
      TabIndex        =   9
      Text            =   "0001"
      Top             =   2040
      Width           =   615
   End
   Begin VB.ComboBox LpduHeader3 
      Height          =   315
      Left            =   3480
      TabIndex        =   4
      Top             =   360
      Width           =   1575
   End
   Begin VB.ComboBox LpduHeader2 
      Height          =   315
      Left            =   2040
      TabIndex        =   3
      Top             =   360
      Width           =   1455
   End
   Begin VB.ComboBox LpduHeader1 
      Height          =   315
      Left            =   360
      TabIndex        =   2
      Top             =   360
      Width           =   1695
   End
   Begin VB.CommandButton Send 
      Caption         =   "Send"
      Height          =   495
      Left            =   2880
      TabIndex        =   0
      Top             =   2040
      Width           =   855
   End
   Begin VB.Label Label9 
      Caption         =   "APDU Header"
      Height          =   255
      Left            =   2280
      TabIndex        =   19
      Top             =   840
      Width           =   1095
   End
   Begin VB.Label Label8 
      Caption         =   "NPDU Service Byte"
      Height          =   255
      Left            =   120
      TabIndex        =   17
      Top             =   840
      Width           =   1455
   End
   Begin VB.Label Label7 
      Caption         =   "Results:"
      Height          =   255
      Left            =   5400
      TabIndex        =   16
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label6 
      Caption         =   "APDU"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   1200
      Width           =   495
   End
   Begin VB.Label Label5 
      Appearance      =   0  'Flat
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Unit"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   1440
      TabIndex        =   8
      Top             =   1800
      Width           =   615
   End
   Begin VB.Label Label4 
      Appearance      =   0  'Flat
      BorderStyle     =   1  'Fixed Single
      Caption         =   "House"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   720
      TabIndex        =   7
      Top             =   1800
      Width           =   615
   End
   Begin VB.Label Label3 
      Appearance      =   0  'Flat
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Dest"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   2400
      Width           =   615
   End
   Begin VB.Label Label2 
      Appearance      =   0  'Flat
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Source"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   2040
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "LPDU Header"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Sub Form_Load()
   PLMon1.Port = "COM1"      ' set serial to Com1
   PLMon1.Mode = 0           ' 0 - DLL Mode, 1 - Monitor Mode
   PLMon1.HouseCode = 1      ' set our house code
   PLMon1.UnitCode = 1       ' set our unit code
   PLMon1.RfRcvSideband = 0  ' Side band select = off
   
   ' Handle Errors Locally
   On Error Resume Next
   
   PLMon1.DriverOpen = True
   If PLMon1.DriverOpen Then
   ' Success
      Debug.Print "CEMonitor on " & PLMon1.Port
   Else
   ' Failure
      MsgBox "Can Not Open CEBus Driver on " & PLMon1.Port
      PLMon1.DriverOpen = False
      Debug.Print "Driver NOT Open"
   End If
   
   ' Setup LpduHeader combo boxes
   'pg 7-59
   LpduHeader1.AddItem ("Ack")
   LpduHeader1.AddItem ("Ack request")
   LpduHeader1.AddItem ("Unack request")
   LpduHeader1.AddItem ("Fail")
   LpduHeader1.AddItem ("Addr ack request")
   LpduHeader1.AddItem ("Addr ack")
   LpduHeader1.AddItem ("Addr unack request")
   LpduHeader1.ListIndex = 2
   
   LpduHeader2.AddItem ("High Priority")
   LpduHeader2.AddItem ("Standard Priority")
   LpduHeader2.AddItem ("Deferred Priority")
   LpduHeader2.ListIndex = 1
   
   LpduHeader3.AddItem ("Basic Service")
   LpduHeader3.AddItem ("Extended Service")
   LpduHeader3.ListIndex = 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
' program close
   If PLMon1.DriverOpen Then PLMon1.DriverOpen = False
End Sub



Private Sub Npdu_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = 13 Then Call Send_Click
End Sub

Private Sub PLMon1_PacketReceive(Message As String, TimeStamp() As Byte)
   Dim Packet As CEBusPacket
   
   Packet.LPDU = Asc(Left$(Message, 1))
   Packet.DestUC = Asc(Mid$(Message, 2, 1)) + (Asc(Mid$(Message, 3, 1)) * 256)
   Packet.DestHC = Asc(Mid$(Message, 4, 1)) + (Asc(Mid$(Message, 5, 1)) * 256)
   Packet.SrcUC = Asc(Mid$(Message, 6, 1)) + (Asc(Mid$(Message, 7, 1)) * 256)
   Packet.SrcHC = Asc(Mid$(Message, 8, 1)) + (Asc(Mid$(Message, 9, 1)) * 256)
   Packet.NPDULen = Len(Message) - 9
   Packet.Npdu = Right$(Message, Packet.NPDULen)
   
   Call ReceivePacket(Packet)
End Sub

Private Sub Send_Click()
    Dim HexPacket As String
    Dim Comment As String
    Dim Packet As CEBusPacket
    
    'HexPacket = "0A 09 00 01 00 01 00 01 00 50 E8 4C"
    'Call HexAscii2Packet(HexPacket, Packet, Comment)
    
    If LpduHeader1.ListIndex > 2 Then
        Packet.LPDU = LpduHeader1.ListIndex + 1
    Else
        Packet.LPDU = LpduHeader1.ListIndex
    End If
    
    Packet.LPDU = Packet.LPDU Or (LpduHeader2.ListIndex * 8)
    Packet.LPDU = Packet.LPDU Or (LpduHeader3.ListIndex * &H40)

    ' source and dest codes
    Packet.SrcHC = Val("&H" & Mid$(SourceHouse, 3, 2)) + 256 * Val("&H" & Mid$(DestUnit, 1, 2))
    Packet.SrcUC = Val("&H" & Mid$(SourceUnit, 3, 2)) + 256 * Val("&H" & Mid$(DestUnit, 1, 2))
    Packet.DestHC = Val("&H" & Mid$(DestHouse, 3, 2)) + 256 * Val("&H" & Mid$(DestUnit, 1, 2))
    Packet.DestUC = Val("&H" & Mid$(DestUnit, 3, 2)) + 256 * Val("&H" & Mid$(DestUnit, 1, 2))
    
    Packet.Npdu = String$(32, " ")
    
    ' NPDU Service Byte
    Mid$(Packet.Npdu, 1, 1) = Chr$(Val("&H" & Mid$(NPDUService.Text, 1, 2)))
    
    ' APDU Header Byte
    Mid$(Packet.Npdu, 2, 1) = Chr$(Val("&H" & Mid$(APDUHeader.Text, 1, 2)))
    
    ' Loop to get ADPU Packet Info
    Dim PktStrEnd As Integer
    Dim Counter As Integer
    Dim PktStrPtr As Integer
    PktStrEnd = Len(Npdu.Text)
    For Counter = 0 To 29
        PktStrPtr = 1 + (Counter * 3)
        If PktStrEnd < PktStrPtr + 1 Then
            Exit For
        End If
        Mid$(Packet.Npdu, Counter + 3, 1) = Chr$(Val("&H" & Mid$(Npdu.Text, PktStrPtr, 2)))
    Next ' Counter
    If Counter > 0 Then
        Packet.Npdu = Left$(Packet.Npdu, Counter + 2)
    End If
    
    Call SendPacket(Packet)
End Sub
