VERSION 5.00
Object = "{F6568F7A-1BEE-11D2-80AF-00A0C9044B04}#1.0#0"; "PLMON32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3705
   ClientLeft      =   60
   ClientTop       =   300
   ClientWidth     =   6105
   LinkTopic       =   "Form1"
   ScaleHeight     =   247
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   407
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox Picture2 
      Height          =   900
      Index           =   3
      Left            =   4320
      ScaleHeight     =   840
      ScaleWidth      =   1140
      TabIndex        =   5
      Top             =   120
      Width           =   1200
   End
   Begin VB.PictureBox Picture2 
      Height          =   900
      Index           =   2
      Left            =   3000
      ScaleHeight     =   840
      ScaleWidth      =   1140
      TabIndex        =   4
      Top             =   120
      Width           =   1200
   End
   Begin VB.PictureBox Picture2 
      Height          =   900
      Index           =   1
      Left            =   1680
      ScaleHeight     =   840
      ScaleWidth      =   1140
      TabIndex        =   3
      Top             =   120
      Width           =   1200
   End
   Begin VB.PictureBox Picture2 
      Height          =   900
      Index           =   0
      Left            =   360
      ScaleHeight     =   840
      ScaleWidth      =   1140
      TabIndex        =   2
      Top             =   120
      Width           =   1200
   End
   Begin VB.PictureBox Picture1 
      Height          =   1800
      Left            =   1680
      ScaleHeight     =   1740
      ScaleWidth      =   2340
      TabIndex        =   1
      Top             =   1200
      Width           =   2400
   End
   Begin PLMon32.PLMon PLMon1 
      Left            =   4800
      Top             =   1320
      _ExtentX        =   873
      _ExtentY        =   609
   End
   Begin VB.CommandButton Send 
      Caption         =   "Send"
      Height          =   495
      Left            =   4680
      TabIndex        =   0
      Top             =   2640
      Width           =   855
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim pics(0 To 5) As New RhinoPic
Dim names(0 To 5) As String
Dim Index(0 To 5) As Variant
Dim fileOpen As Boolean
Dim lastNPDU
Dim lastPicNum

Private Sub Form_Load()
    Index(0) = 0
    Index(1) = 1
    Index(2) = 2
    Index(3) = 3
    Index(4) = 4
    Index(5) = 5
    
    'Picture1.Width = pics(index(1)).GetWidth
    'Picture1.Height = pics(index(1)).GetHeight
    
    'Picture2.Width = pics(index(2)).GetWidth / 2 ' small image is 1/2 size
    'Picture2.Height = pics(index(2)).GetHeight / 2 ' small image is 1/2 size
    
    
    PLMon1.Port = "COM1"      ' set serial to Com1
    PLMon1.Mode = 0           ' 0 - DLL Mode, 1 - Monitor Mode
    PLMon1.HouseCode = 1      ' set our house code
    PLMon1.UnitCode = 1       ' set our unit code
    PLMon1.RfRcvSideband = 0  ' Side band select = off
    
    ' Handle Errors Locally
    On Error Resume Next
    
    PLMon1.DriverOpen = True
    If PLMon1.DriverOpen Then
    ' Success
        Debug.Print "CEMonitor on " & PLMon1.Port
    Else
        ' Failure
        MsgBox "Can Not Open CEBus Driver on " & PLMon1.Port
        PLMon1.DriverOpen = False
        Debug.Print "Driver NOT Open"
    End If
    names(1) = "7-21_14-38-07"
    names(2) = "7-21_14-38-07"
    names(3) = "7-21_14-38-07"
    names(4) = "7-21_14-38-07"
    names(5) = "7-21_14-38-07"
End Sub

Private Sub Form_Unload(Cancel As Integer)
' program close
   If PLMon1.DriverOpen Then PLMon1.DriverOpen = False
End Sub

Private Sub Npdu_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = 13 Then Call Send_Click
End Sub

Private Sub Picture1_Paint()
    pics(Index(1)).DrawLarge Picture1.hDC
End Sub



Private Sub Picture2_Paint(ControlIndex As Integer)
    pics(Index(ControlIndex + 2)).DrawSmall Picture2(ControlIndex).hDC
End Sub

Private Sub PLMon1_PacketReceive(Message As String, TimeStamp() As Byte)
   Dim Packet As CEBusPacket
   
   Packet.LPDU = Asc(Left$(Message, 1))
   Packet.DestUC = Asc(Mid$(Message, 2, 1)) + (Asc(Mid$(Message, 3, 1)) * 256)
   Packet.DestHC = Asc(Mid$(Message, 4, 1)) + (Asc(Mid$(Message, 5, 1)) * 256)
   Packet.SrcUC = Asc(Mid$(Message, 6, 1)) + (Asc(Mid$(Message, 7, 1)) * 256)
   Packet.SrcHC = Asc(Mid$(Message, 8, 1)) + (Asc(Mid$(Message, 9, 1)) * 256)
   Packet.NPDULen = Len(Message) - 9
   Packet.Npdu = Right$(Message, Packet.NPDULen)
   
   'Call ReceivePacket(Packet)
   If Packet.Npdu <> lastNPDU Then
        'Debug.Print Mid$(Packet.Npdu, 3)
        ProcRhinoResults Packet.Npdu
    Else
        Debug.Print "same packet!!!"
    End If
End Sub

Private Sub Send_Click()
    Send.Visible = False
    lastPicNum = 255
    SendRhinoCommand ("G")
End Sub

Public Sub SendRhinoCommand(cmd As String)
    Dim Packet As CEBusPacket
    
    Packet.LPDU = &HA

    ' source and dest codes
    Packet.SrcHC = 1
    Packet.SrcUC = 1
    Packet.DestHC = 1
    Packet.DestUC = 2
    
    Packet.Npdu = String$(3, " ")
    
    ' NPDU Service Byte
    Mid$(Packet.Npdu, 1, 1) = &H50
    
    ' APDU Header Byte
    Mid$(Packet.Npdu, 2, 1) = 0
    
    ' ADPU Data
    Mid$(Packet.Npdu, 3, 1) = Mid$(cmd, 1, 1)
    Call SendPacket(Packet)
End Sub

Sub ProcRhinoResults(Npdu As String)
    Dim waitTime
    Dim i As Integer
    Dim temp As Integer
    Dim picNum As Integer
    Dim loopVal As Integer
    Dim j As Integer
    If Mid$(Npdu, 3, 3) = "IMG" Then
        picNum = Asc(Mid$(Npdu, 6, 1))
        If picNum = 0 Then
            loopVal = picNum + 256 - lastPicNum
        Else
            loopVal = picNum - lastPicNum
        End If
        
        lastPicNum = picNum
        For i = 2 To loopVal
            For j = 1 To 24
            Put #1, , Chr$(0)
            Call pics(Index(0)).addData(0)
            Next
        Next
        If loopVal <> 0 Then
            For i = 7 To Len(Npdu)
                Put #1, , Mid$(Npdu, i, 1)
                Call pics(Index(0)).addData(Asc(Mid$(Npdu, i, 1)))
            Next
        End If
    Else
        If Mid$(Npdu, 3, 18) = "Done Sending Image" Then
            Close #1
            fileOpen = False
            Call pics(Index(0)).PrepareImage
            Call pics(Index(0)).saveGif(names(Index(0)) & ".gif")
            temp = Index(0)
            Index(0) = Index(5)
            Index(5) = Index(4)
            Index(4) = Index(3)
            Index(3) = Index(2)
            Index(2) = Index(1)
            Index(1) = temp
            Picture1.Refresh
            Picture2(0).Refresh
            Picture2(1).Refresh
            Picture2(2).Refresh
            Picture2(3).Refresh
            'WriteWebPage
        ElseIf Mid$(Npdu, 3, 13) = "Sending Image" Then
            fileOpen = True
            names(Index(0)) = Format(Date, "m-d_") & Format(Time, "hh-mm-ss")
            Open "e:\kent\VB-PL-pic\images\" & names(Index(0)) & ".pic" For Binary As #1
        End If
    End If

End Sub

Sub WriteWebPage()
Dim fileTime As String
Dim i As Integer
Dim hr As Integer
Open "pictures.html" For Output As #5
Print #5, "<HTML><HEAD></HEAD><BODY>"
Print #5, "<H1>The <FONT COLOR=" & Chr$(34) & "#FF0000" & Chr$(34) & ">Powercam</FONT></H1>"
Print #5, "<H3>Date: " & Format(Date, "m-d-yy") & "</H3>"
For i = 1 To 5
    fileTime = Mid$(names(Index(i)), Len(names(Index(i))) - 7, 5)
    hr = val(Left$(fileTime, 2))
    If hr > 12 Then
        Print #5, Format(hr - 12, "##"); ":"; Right$(fileTime, 2) & "pm"
    Else
        Print #5, Format(hr, "##"); ":"; Right$(fileTime, 2) & "am"
    End If
    Print #5, "<IMG SRC=" & Chr$(34) & names(Index(i)) & ".gif" & Chr$(34) & " HSPACE=20 VSPACE=20 HEIGHT=120 WIDTH=160 ALIGN=ABSCENTER><P>"
Next
Print #5, "</BODY></HTML>"
Close #5
End Sub
