
/*
    Created by   : Vishal Dalal
    Last updated : 7/30/1999
    Project      : Classroom 2000

    Note : This module is written for Webtracker.
*/

#include "constants"

typedef struct {              /* In conjunction with class_and_room.txt file */
    char classroom[50];
    char classname[50];
    char start_time_hour[5];
    char start_time_minute[5];
    char days[10];
    char duration[5];
    char classroom_ip[30];
    char title[128];
} class_room_record;

class_room_record *extract_info_from_visited_URL(char **strs)

/*  
    Purpose : Extracts fields from the logged URL

    Input : The URL

    Output : Structure containing various fields  
*/

{
 proxylog_entry pl;
 int get_class_and_room(char day_of_year[],char year[],char time_hour[],char time_minute[],char day_of_week[],char name[],class_room_record *pt);
 class_room_record *entry;

 entry = (class_room_record *)malloc(sizeof(class_room_record));

 strcpy(pl.day_of_year,strtok(strs[0]," "));
 strcpy(pl.year,strtok(NULL," "));
 strcpy(pl.time_hour,strtok(NULL," "));
 strcpy(pl.time_minute,strtok(NULL," "));
 strcpy(pl.day_of_week,strtok(NULL," "));
 strcpy(pl.name,strtok(strs[2]," "));
 strcpy(pl.url,strtok(strs[4]," "));
 get_class_and_room(pl.day_of_year,pl.year,pl.time_hour,pl.time_minute,pl.day_of_week,pl.name,entry);
 return(entry);
}


int get_class_and_room(char day_of_year[],char year[],char time_hour[],char time_minute[],char day_of_week[],char name[],class_room_record *pt)

/*
  Purpose : Searches the class file for a match.  The parameters
            used in the search are precisely the date, time and
            the ip-address.

  Input :
  1)  day_of_year,year,time_hour,time_minute,day_of_week,name
          This is the dynamic data being generated as requests are
          being logged by the proxy.

  2)  classroom record*pt
          This is the static data taken from the class file.  Input
          is read in record by record.

  Output : 1(true) if we find a matching classname; 0(false) otherwise.
           Also, classname and classroom are passed back as modifications
           to the class_room_record pointer pt.
*/


{
 char line[150];      /* to hold one record of class_and_room.txt file */
 int j,i = 0,s = 0;
 FILE *fp;
 char *dummy, *room;
 char **ip_list;

 char *ip_to_name(char *ip);
 int days_match(char day_of_year[],char year[],char day_of_week[],class_room_record *pt);
 int time_within(char time_hour[],char time_minute[],class_room_record *pt);
 char *find_room(char *ip);
 char **get_ip_list(char *room);

 fp = fopen(CLASS_AND_ROOM_TXT,"r");
 if (fp != NULL)  {
    fgets(line,150,fp);
    if (line[0] == '#')
       fgets(line,150,fp);
    while (!feof(fp)) {
           i = 0;
           strcpy(pt->classname,strtok(line,":"));
           strcpy(pt->start_time_hour,strtok(NULL,":"));
           strcpy(pt->start_time_minute,strtok(NULL,":"));
           strcpy(pt->days,strtok(NULL,":"));
           strcpy(pt->duration,strtok(NULL,":"));
           strcpy(pt->classroom_ip,strtok(NULL,":"));
           strcpy(pt->title,strtok(NULL,"\0"));
           room = find_room(pt->classroom_ip);
           strcpy(pt->classroom,room);
           ip_list = get_ip_list(room);
           while (strncmp(ip_list[i],"NULL",4))  {
                 dummy = ip_to_name(ip_list[i]);
                 if  (!strncmp(name,dummy,strlen(name))) {
                     if (days_match(day_of_year,year,day_of_week,pt) && time_within(time_hour,time_minute,pt))
                        {
                           for (j=0; j < MAX_STR_LEN; ++j)
                               free(ip_list[j]);
                           free(ip_list);
                           free(room);
                           free(dummy);
                           fclose(fp);
                           return 1;
                        }
                 }
                 free (dummy);
                 ++i;
           }
           for (j=0; j < MAX_STR_LEN; ++j)
                free(ip_list[j]);
           free(ip_list);
           free (room);
           fgets(line,150,fp);
    }
 strcpy(pt->classname,"unrecognized");
 strcpy(pt->classroom,"undefined");
 fclose(fp);
 }
 return 0;
}


char *find_room(char *ip)

/*  
    Purpose : Given an IP address, finds the classroom in which machine with
              the given IP address is located

    Input : Ip address

    Output : Room name
*/

{
 FILE *rp;
 char *local_ip;
 char *line;
 char *room;

 local_ip = (char *)malloc(MAX_STR_LEN * sizeof(char));
 room = (char *)malloc(MAX_STR_LEN * sizeof(char));
 line = (char *)malloc(MAX_STR_LEN * sizeof(char));
 rp = fopen(ROOM_IP_MAPPING_TXT,"r");
 if (rp != NULL) {
    fgets(line,MAX_STR_LEN,rp);
    if (line[0] == '#')
       fgets(line,MAX_STR_LEN,rp);
    while (!feof(rp)) {
           strcpy(local_ip,strtok(line,":"));
           strcpy(room,strtok(NULL,"\0"));
           if (!strcmp(local_ip,ip)) {          /*  IP addresses match! */
              fclose(rp);
              free(line);
              free(local_ip);
              return room;
           }
           fgets(line,MAX_STR_LEN,rp);
    }
    fclose(rp);
 }
 free(line);
 free(local_ip);
 free(room);
 fclose(rp);
 return "undefined";
}


char **get_ip_list(char *room)

/*  
    Purpose : Gets all the IP addresses of machines present in a classroom

    Input : The room name

    Output : List of IP addresses 
*/

{
 FILE *iplist;
 char *ip;
 char *local_room;
 char *line;
 char **pass_ptr;
 int j,i = 0;

 ip = (char *)malloc(MAX_STR_LEN * sizeof(char));
 local_room = (char *)malloc(MAX_STR_LEN * sizeof(char));
 iplist = fopen(ROOM_IP_MAPPING_TXT,"r");
 if (iplist != NULL) {
    line = (char *)malloc(MAX_STR_LEN * sizeof(char));
    pass_ptr = (char **)malloc(MAX_STR_LEN * sizeof(char *));
    for (j=0;j < MAX_STR_LEN;++j)
        pass_ptr[j] = (char *)malloc(MAX_STR_LEN * sizeof(char));
    fgets(line,MAX_STR_LEN,iplist);
    if (line[0] == '#')
       fgets(line,MAX_STR_LEN,iplist);
    while (!feof(iplist)) {
           strcpy(ip,strtok(line,":"));
           strcpy(local_room,strtok(NULL,"\0"));
           if (!strcmp(local_room,room)) {
              strcpy(pass_ptr[i],ip);
              ++i;
           }
           fgets(line,MAX_STR_LEN,iplist);
    }
    strcpy(pass_ptr[i],"NULL");
    free(line);
    fclose(iplist);
 }
 else
      strcpy(pass_ptr[i],"NULL");
 free(ip);
 free(local_room);
 return pass_ptr;
}


char *ip_to_name(char *ip)

/*  
    Purpose : Maps from ip address to hostname

    Input : Ip address in the form of 123.23.343.434, for example

    Output : Hostname in the form of fce.cc.gatech.edu, for example
*/

{
  unsigned long addr;
  struct hostent *ip_struct;

  ip_struct = (struct hostent *)malloc(sizeof(struct hostent*));
  addr = inet_addr(ip);
  ip_struct = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET);
  if (ip_struct == NULL)
   {
    free (ip_struct);
    return "NULL";
   }
  else
    return ip_struct->h_name;
}


int days_match(char day_of_year[],char year[],char day_of_week[],class_room_record *pt)

/*
   Purpose : See whether year,quarter,day_of_week match

   Input : day_of_year,year,day_of_week
              From request being logged dynamically
           class_room_record *pt
              Static records taken from the class file

   Output : 1(true) if a match is found; 0(false) otherwise
*/

{
 int i;
 char pt_local_classname[MAX_STR_LEN];
 char pt_local_class[MAX_STR_LEN];
 char pt_local_year[MAX_STR_LEN];
 char pt_local_quarter[MAX_STR_LEN];
 
 strcpy(pt_local_classname,pt->classname);
 strcpy(pt_local_class,strtok(pt_local_classname,"_"));
 strcpy(pt_local_year,strtok(NULL,"_"));
 strcpy(pt_local_quarter,strtok(NULL,"\0"));
 if (!strcmp(pt_local_year,year)) {          /*  Years match?  */
     if (!strcmp(pt_local_quarter,"Fall"))         /*  Quarters match?  */
        if (!((strtol(day_of_year,NULL,10) >= FALL_START_DATE) && (strtol(day_of_year,NULL,10) <= FALL_END_DATE)))
            return 0;
     if (!strcmp(pt_local_quarter,"Winter"))
        if (!((strtol(day_of_year,NULL,10) >= WINTER_START_DATE) && (strtol(day_of_year,NULL,10) <= WINTER_END_DATE)))
            return 0;
     if (!strcmp(pt_local_quarter,"Spring"))
        if (!((strtol(day_of_year,NULL,10) >= SPRING_START_DATE) && (strtol(day_of_year,NULL,10) <= SPRING_END_DATE)))
            return 0;
     if (!strcmp(pt_local_quarter,"Summer"))
        if (!((strtol(day_of_year,NULL,10) >= SUMMER_START_DATE) && (strtol(day_of_year,NULL,10) <= SUMMER_END_DATE)))
            return 0;
                                           /*  Day_of_week matches?  */
      if (!strcmp(day_of_week,"Sun")) {
         for (i=0; i < strlen(pt->days); ++i)
             if (pt->days[i] == 'U')
                  return 1;
         return 0;
      }
      if (!strcmp(day_of_week,"Thu")) {
         for (i=0; i < strlen(pt->days); ++i)
             if (pt->days[i] == 'R')
                  return 1;
         return 0;
      }
      if ((!strcmp(day_of_week,"Mon")) || (!strcmp(day_of_week,"Tue"))
       || (!strcmp(day_of_week,"Wed")) || (!strcmp(day_of_week,"Fri"))
       || (!strcmp(day_of_week,"Sat"))) {
             for (i=0; i < strlen(pt->days); ++i)
               if (pt->days[i] == day_of_week[0])
                  return 1;
             return 0;
      }
 }                                   /*  years do not match  */
 return 0;              /*  We have not found a match:((  */
}


int time_within(char time_hour[],char time_minute[],class_room_record *pt)

/*  
    Purpose : See whether the time matches

    Input : time_hour,time_minute
                From request being logged dynamically
            class_room_record *pt
                Static records taken from the class file

    Output : 1(true) if a match is found; 0(false) otherwise
*/

{
 int time_in_minutes;
 int pt_time_in_minutes;

 time_in_minutes = strtol(time_hour,NULL,10) * 60 + strtol(time_minute,NULL,10);
 pt_time_in_minutes = strtol(pt->start_time_hour,NULL,10) * 60 + strtol(pt->start_time_minute,NULL,10);
 if ((time_in_minutes >= pt_time_in_minutes) && (time_in_minutes <= (pt_time_in_minutes + strtol(pt->duration,NULL,10))))
    return 1;
 else if ((pt_time_in_minutes + strtol(pt->duration,NULL,10))/1440 == 1)
         if (time_in_minutes <= ((pt_time_in_minutes + strtol(pt->duration,NULL,10))%1440))
            return 1;
 return 0;
}
