
/*
   Created by    : Vishal Dalal
   Last Modified : 7/30/1999
   Project       : Classroom 2000

   Note : This CGI script queries the proxylog file and extracts relevant
          URL's for display.  The query is in the form of a GET request
*/           

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../src/constants"

#define MAX_STR_LENGTH 1024

#define CGI_ARRAY_COUNT_LIMIT 30
#define PAIRLIST_ARRAY_COUNT_LIMIT 15

typedef struct {
   char *cgivars[CGI_ARRAY_COUNT_LIMIT];
   int paircount;
} cgi_vars_and_count; 


/** Convert a two-char hex string into the char it represents **/
char x2c(char *what) 
{
   register char digit;

   digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
   digit *= 16;
   digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
   return(digit);
}

/** Reduce any %xx escape sequences to the characters they represent **/
void unescape_url(char *url) 
{
    register int i,j;

    for(i=0,j=0; url[j]; ++i,++j) {
        if((url[i] = url[j]) == '%') {
            url[i] = x2c(&url[j+1]) ;
            j+= 2 ;
        }
    }
    url[i] = '\0' ;
}


/** Read the CGI input and place all name/val pairs into list.        **/
/** Print list containing name1, value1, name2, value2, ... , NULL  **/

cgi_vars_and_count *getcgivars() {
    FILE *cgi;
    register int i ;
    char *request_method;
    int content_length;
    char *cgiinput;
    char *cgivars[CGI_ARRAY_COUNT_LIMIT];
    char *pairlist[PAIRLIST_ARRAY_COUNT_LIMIT];
    int paircount;
    char *nvpair;
    char *eqpos;
    size_t size_cgiinput;
    cgi_vars_and_count *cgi_struct;
    
    int search_using_sgrep(char *cgivars[],int paircount);

    /** Depending on the request method, read all CGI input into cgiinput **/
    /** (really should produce HTML error messages, instead of exit()ing) **/
  
    cgi_struct = (cgi_vars_and_count *)malloc(sizeof(cgi_vars_and_count));
    for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i)
     cgi_struct->cgivars[i] = (char *)malloc(MAX_STR_LENGTH * sizeof(char));  
    for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i) 
        cgivars[i] = (char *)malloc(MAX_STR_LENGTH * sizeof(char)); 
    for (i=0; i < PAIRLIST_ARRAY_COUNT_LIMIT ;++i)    
        pairlist[i] = (char *)malloc(MAX_STR_LENGTH * sizeof(char));  

    request_method= getenv("REQUEST_METHOD") ;
    if (!strcmp(request_method, "GET") || !strcmp(request_method, "HEAD") ) {
        cgiinput= strdup(getenv("QUERY_STRING")) ;
        size_cgiinput = strlen(cgiinput);
        cgiinput[size_cgiinput+1] = '\0'; 
    }  
    else 
      if (!strcmp(request_method, "POST")) {  
        /* strcasecmp() is not supported in Windows-- use strcmpi() instead */
        if ( strcasecmp(getenv("CONTENT_TYPE"), "application/x-www-form-urlencoded")) {
            printf("getcgivars(): Unsupported Content-Type.\n") ;
            exit(1) ;
        }

        if ( !(content_length = atoi(getenv("CONTENT_LENGTH"))) ) {
            printf("getcgivars(): No Content-Length was sent with the POST request.\n") ;
            exit(1) ;
        }
        
        if (!fread(cgiinput, content_length, 1, stdin)) {
            printf("Couldn't read CGI input from STDIN.\n") ;
            exit(1) ;
        }
        cgiinput[content_length]='\0' ;
      }
      else {
             printf("getcgivars(): unsupported REQUEST_METHOD\n") ;
             exit(1) ;
           }   

    /** Change all plusses back to spaces **/
    for(i=0; cgiinput[i]; i++) if (cgiinput[i] == '+') cgiinput[i] = ' ' ;  

    /** First, split on "&" to extract the name-value pairs into pairlist **/
    paircount= 0 ;
    nvpair= strtok(cgiinput, "&") ;
    while (nvpair != NULL) {
       pairlist[paircount++]= strdup(nvpair) ;
       nvpair= strtok(NULL, "&") ;
    }  

    /** Then, from the list of pairs, extract the names and values **/
    for (i= 0; i<paircount; i++) {
        if (eqpos=strchr(pairlist[i], '=')) {
           strcpy(cgivars[i*2],strtok(pairlist[i],"="));
           unescape_url(strcpy(cgivars[i*2+1],eqpos+1)) ;
        } 
        else {
              unescape_url(strcpy(cgivars[i*2+1],"")) ;
              unescape_url(strcpy(cgivars[i*2],pairlist[i])) ;
             }
    }
  
    for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i) 
        strcpy(cgi_struct->cgivars[i],cgivars[i]);
    cgi_struct->paircount = paircount; 

/** Free the pointer arrays - we no longer need them **/  
    for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i) 
        free(cgivars[i]); 
    for (i=0; i < PAIRLIST_ARRAY_COUNT_LIMIT ;++i) 
        free(pairlist[i]);

    return cgi_struct; 
}

/***************** end of the getcgivars() module ********************/

void display()
{
 
 char buffer[80];
 FILE *fp;
 
 if ((fp = fopen(SEARCH_RESULTS_XML,"r")) == NULL)
   printf("error opening file");
 else
  {
   fgets(buffer,80,fp);
   while (!feof(fp))
    { 
      if (strncmp(buffer,"</entry><entry>",15) == 0)
         printf("</entry>\n<entry>\n");       /* hack! */
      else 
         printf("%s", buffer);
      fgets(buffer,80,fp);
    }
  fclose(fp);
  } 
}


int search_using_sgrep(char *cgivars[],int paircount)
{  
  FILE *fp_grepexp;
  int i;

  fp_grepexp = fopen(GREPEXP,"w"); 
 
  fprintf(fp_grepexp,"inner(\"<entry>\"..\"</entry>\")");
  for (i=0; i < (paircount * 2); i = i + 2)
      fprintf(fp_grepexp," containing (\"<%s>%s</%s>\")",cgivars[i],cgivars[i+1],cgivars[i]);
  fclose(fp_grepexp);
  return;
}

void search()
{
 char command_holder[MAX_STR_LEN];
 char command[MAX_STR_LEN];
 FILE *fp_search_result;
 fp_search_result = fopen(SEARCH_RESULTS_XML,"w");

 fprintf(fp_search_result,"<XML version = \"1.0\"?>\n");
 fprintf(fp_search_result,"<proxylog>\n");
 fclose(fp_search_result);

 strcpy(command_holder,SGREP);
 strcat(command_holder," -i -f ");
 strcat(command_holder,GREPEXP);
 strcat(command_holder," ");
 strcat(command_holder,PROXYLOG);
 strcat(command_holder," >> ");
 strcat(command_holder,SEARCH_RESULTS_XML);
 strcpy(command,command_holder);

 // At this point command is :
 // "SGREP -i -f GREPEXP PROXYLOG >> SEARCH_RESSULTS_XML"

 system(command); 

 strcpy(command_holder,"echo \"</proxylog>\" >> ");
 strcat(command_holder,SEARCH_RESULTS_XML);
 strcpy(command,command_holder);

 // At this point command is :
 // "echo \"</proxylog>\" >> SEARCH_RESULTS_XML"
 
 system(command);
 
} 

int main()
{
 cgi_vars_and_count *cgi_struct;
 int i;

 cgi_vars_and_count *getcgivars();
 void display();
 int search_using_sgrep(char *cgivars[],int paircount); 
 void search();
 
 cgi_struct = (cgi_vars_and_count *)malloc(sizeof(cgi_vars_and_count));
 for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i)
     cgi_struct->cgivars[i] = (char *)malloc(MAX_STR_LENGTH * sizeof(char));  
 printf ("Content-type: text/plain\n\n"); 
 cgi_struct = getcgivars();
 search_using_sgrep(cgi_struct->cgivars,cgi_struct->paircount);
 search();
 display(); 
 for (i=0; i < CGI_ARRAY_COUNT_LIMIT ;++i)
     free (cgi_struct->cgivars[i]);
 free (cgi_struct);
 return 0; 
} 
