/*---------------------------------------------------------------------------------

$Id: main.cpp,v 1.13 2008-12-02 20:21:20 dovoto Exp $

Simple console print demo
-- dovoto


---------------------------------------------------------------------------------*/
#include <nds.h>
#include <stdio.h>


void initBackgrounds();
void displayStarField();	
void initVideo();


const unsigned int starFieldBitmapLen = 8192; //###BACKGROUND SETUP
const unsigned int starFieldBitmap[]={  //###BACKGROUND SETUP 
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF80AF,
	0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD8135,
	0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,0x863F8199,
	0x81358199,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81998135,0x863F81DD,
	0x819981DD,0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,0x81DD8199,0x863F81DD,
	0x81DD81DD,0x81358199,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x819980AF,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x819981DD,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD8135,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD8199,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF8199,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,0x81DD81DD,0x863F81DD,0x863F81DD,
	0x863F81DD,0x81DD81DD,0x813581DD,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x819980AF,0x81DD81DD,0x819981DD,0x863F81DD,
	0x819981DD,0x81DD81DD,0x819981DD,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD8135,0x819981DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x819981DD,0x81DD81DD,0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD8199,0x813581DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x813581DD,0x81DD81DD,0x80AF8199,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x80AF81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x80AF81DD,0x81DD81DD,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x80AF8199,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x80AF81DD,0x81DD8199,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x80AF8135,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x80AF81DD,0x81DD8135,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x80AF8135,0x863F81DD,0x863F81DD,
	0x863F81DD,0x80AF81DD,0x81DD8135,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x819981DD,0x80AF8135,0x819981DD,0x863F81DD,
	0x819981DD,0x80AF81DD,0x81998135,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF8000,0x813581DD,0x863F80AF,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x863F81DD,0x813580AF,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80AF9084,0x80AF81DD,0x81DD863F,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF863F,0x80AF81DD,0x80009084,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x90848000,0x80AF9CE7,0x863F81DD,0x819981DD,0xB0E08135,0xB0E0B0E0,
	0xB0E0B0E0,0x81998135,0x863F81DD,0x80AF81DD,0x90849CE7,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0xB18C9084,0x80AF9CE7,0x819981DD,0xB0E08135,0xD180B0E0,0xEA21EA21,
	0xD180EA21,0xB0E0B0E0,0x81998135,0x80AF81DD,0xB18C9CE7,0x80009084,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x80AF9084,0x813581DD,0xC540B0E0,0xD180D180,0xEA21EA21,
	0xD180EA21,0xC540D180,0x8135B0E0,0x80AF81DD,0xB18C9084,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xA529A529,0x80AF9CE7,0xB0E081DD,0xC540C540,0x80AFD180,0x80AF80AF,
	0x80AF80AF,0xC540D180,0xB0E0C540,0x80AF81DD,0xA5299CE7,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18C9CE7,0x80AF9CE7,0xB0E081DD,0x80AFC540,0x813580AF,0x863F8199,
	0x81358199,0x80AF80AF,0xB0E0C540,0x80AF81DD,0xB18C9CE7,0x90849CE7,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CB18C,0x80AF9CE7,0x80AF81DD,0x813580AF,0x81DD8199,0x863F81DD,
	0x81DD81DD,0x81358199,0x80AF80AF,0x80AF81DD,0xB18C9CE7,0x9084B18C,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x80AF9CE7,0x80AF81DD,0x81998135,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x819981DD,0x80AF8135,0x80AF81DD,0xB18C9CE7,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x80AF9CE7,0x80AF81DD,0x81DD8199,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF8199,0x80AF81DD,0xB18C9CE7,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x80AF9CE7,0x80AF81DD,0x81DD81DD,0x81DD863F,0x863F81DD,
	0x81DD81DD,0x81DD863F,0x80AF81DD,0x80AF81DD,0xB18C9CE7,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x80AF9CE7,0x80AF81DD,0x81DD81DD,0x81DD8199,0x863F81DD,
	0x81DD81DD,0x81DD8199,0x80AF81DD,0x80AF81DD,0xB18C9CE7,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x813580AF,0x80AF81DD,0x81DD81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF81DD,0x813581DD,0xB18C80AF,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x863F80AF,0x80AF81DD,0x81DD81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF81DD,0x863F81DD,0xB18C80AF,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0xB18CA529,0x81DD80AF,0x80AF81DD,0x81DD81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x80AF81DD,0x81DD81DD,0xB18C80AF,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0x80AFA529,0x81DD8135,0x80AF81DD,0x80AF8199,0x819980AF,0x863F81DD,
	0x819981DD,0x80AF80AF,0x80AF8199,0x81DD81DD,0x80AF8135,0x9084A529,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x90848000,0x813580AF,0x81DD863F,0x80AF81DD,0x81DD80AF,0x80AF81DD,0x863F81DD,
	0x80AF81DD,0x81DD81DD,0x80AF80AF,0x81DD81DD,0x8135863F,0x908480AF,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80AF8000,0x863F8135,0x81DD81DD,0x80AF81DD,0x863F80AF,0x80AF863F,0x863F8199,
	0x80AF8199,0x863F863F,0x80AF80AF,0x81DD81DD,0x863F81DD,0x80AF8135,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x813580AF,0x81DD863F,0x81DD81DD,0x80AF8199,0x863F8199,0x8199863F,0x863F80AF,
	0x819980AF,0x863F863F,0x80AF8199,0x81DD8199,0x81DD81DD,0x8135863F,0x800080AF,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80AF8000,0x863F8135,0x81DD81DD,0x81DD81DD,0x80AF8135,0x863F81DD,0x81DD863F,0x863F80AF,
	0x81DD80AF,0x863F863F,0x80AF81DD,0x81DD8135,0x81DD81DD,0x863F81DD,0x80AF8135,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x813580AF,0x81DD863F,0x863F81DD,0x81DD81DD,0x813580AF,0x863F81DD,0x81DD863F,0x80AF8135,
	0x81DD8135,0x863F863F,0x813581DD,0x81DD80AF,0x863F81DD,0x81DD81DD,0x8135863F,0x800080AF,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,
	0x863F8135,0x81DD81DD,0x819981DD,0x81DD81DD,0x813580AF,0x863F81DD,0x81DD863F,0x80AF8135,
	0x81DD8135,0x863F863F,0x813581DD,0x81DD80AF,0x819981DD,0x81DD81DD,0x863F81DD,0x80AF8135,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,
	0x81DD863F,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x8135863F,
	0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x863F8135,
	0x81DD81DD,0x81DD863F,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD863F,0x863F81DD,
	0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,0x81DD863F,
	0x81DD81DD,0x81DD8199,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD8199,0x81DD81DD,
	0x8135863F,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x863F8135,0x81DD81DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,
	0x863F81DD,0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x813580AF,0x81DD863F,0x863F81DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD863F,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD863F,0x81DD81DD,0x81DD81DD,0x863F81DD,
	0x81DD81DD,0x8135863F,0x800080AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x863F8135,0x81DD81DD,0x819981DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD8199,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD8199,0x81DD81DD,0x81DD81DD,0x819981DD,
	0x81DD81DD,0x863F81DD,0x80AF8135,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD863F,0x81DD81DD,0x81DD81DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,
	0x81DD81DD,0x81DD81DD,0x80AF863F,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x81DD863F,0x81DD81DD,
	0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x819980AF,0x863F81DD,0x81DD863F,0x80AF8199,
	0x81DD8199,0x863F863F,0x819981DD,0x81DD80AF,0x81DD81DD,0x81DD81DD,0x81DD81DD,0x81DD81DD,
	0x81DD81DD,0x81DD863F,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x81DD8199,0x90848135,
	0x90849084,0x90849084,0x90849084,0x90849084,0x813580AF,0x863F81DD,0x81DD863F,0x80AF8135,
	0x81DD8135,0x863F863F,0x813581DD,0x908480AF,0x90849084,0x90849084,0x90849084,0x90849084,
	0x81DD8135,0x81DD8199,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x81DD81DD,0xA5299084,
	0xB18CB18C,0xB18CB18C,0xB18CB18C,0xA529B18C,0x813580AF,0x863F8199,0x8199863F,0x80AF8135,
	0x81998135,0x863F863F,0x81358199,0xA52980AF,0xB18CB18C,0xB18CB18C,0xB18CB18C,0xA529B18C,
	0x81DD9084,0x81DD81DD,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x81DD81DD,0xB18C9084,
	0xA529A529,0xA529A529,0xA529A529,0xA529A529,0x90849084,0x90848135,0x81359084,0x90849084,
	0x81359084,0x90849084,0x90848135,0xA5299084,0xA529A529,0xA529A529,0xA529A529,0xB18CA529,
	0x81DD9084,0x81DD81DD,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x81DD81DD,0x81DD81DD,0x90849084,
	0x90849084,0x90849084,0x90849084,0x90849084,0x9CE79084,0xB18C9084,0x9084B18C,0x90849CE7,
	0x90849CE7,0xB18CB18C,0x9CE79084,0x90849084,0x90849084,0x90849084,0x90849084,0x90849084,
	0x81DD9084,0x81DD81DD,0x80AF81DD,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80AF8000,0x80AF80AF,0x80AF80AF,0x80008000,
	0x80008000,0x80008000,0x8C638000,0x9CE794A5,0x9CE79084,0xB18CA529,0xA529B18C,0x90849CE7,
	0xA5299CE7,0xB18CB18C,0x9CE7A529,0x9CE79084,0x8C6394A5,0x80008000,0x80008000,0x80008000,
	0x80AF8000,0x80AF80AF,0x80AF80AF,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x8C638000,0x8C638C63,0x9CE79084,0xB18CA529,0xA529B18C,0x90849CE7,
	0xA5299CE7,0xB18CB18C,0x9CE7A529,0x8C639084,0x8C638C63,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x90849084,0x90849084,0x90849084,0x90849084,
	0x90849084,0x90849084,0x90849084,0x80009084,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,
	0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000,0x80008000
};



static const int DMA_CHANNEL = 3;

//---------------------------------------------------------------------------------
int main(void) {
	//---------------------------------------------------------------------------------
	powerOn(POWER_ALL_2D);
	lcdMainOnBottom(); // Place the main screen on the bottom physical screen
	initVideo();
	initBackgrounds();
	displayStarField();

	consoleDemoInit (); //debug console on top. To print helloWorld here do: fprintf (stderr, "helloWorld");
	consoleDebugInit(DebugDevice_CONSOLE);
	



	return 0;
}


void initVideo() { 
	/*
	*  Map VRAM to display a background on the main and sub screens.
	* 
	*  The vramSetMainBanks function takes four arguments, one for each of the
	*  major VRAM banks. We can use it as shorthand for assigning values to
	*  each of the VRAM bank's control registers.
	*
	*  We map banks A and B to main screen background memory. This gives us
	*  256KB, which is a healthy amount for 16-bit graphics.
	*
	*  We map bank C to sub screen background memory.
	*
	*  We map bank D to LCD. This setting is generally used for when we aren't
	*  using a particular bank.
	*/
	vramSetMainBanks(VRAM_A_MAIN_BG_0x06000000,
		VRAM_B_MAIN_BG_0x06020000,
		VRAM_C_SUB_BG_0x06200000,
		VRAM_D_LCD);

	/*  Set the video mode on the main screen. */
	videoSetMode(MODE_5_2D | // Set the graphics mode to Mode 5
		//DISPLAY_BG2_ACTIVE | // Enable BG2 for display
		DISPLAY_BG3_ACTIVE); //Enable BG3 for display

	/*  Set the video mode on the sub screen. */
	videoSetModeSub(MODE_5_2D | // Set the graphics mode to Mode 5
		DISPLAY_BG3_ACTIVE); // Enable BG3 for display
}



void initBackgrounds(){ 
	/*  Set up affine background 3 on main as a 16-bit color background. */
	REG_BG3CNT = BG_BMP16_128x128 |
		BG_BMP_BASE(0) | // The starting place in memory
		BG_PRIORITY(0); // A low priority

	/*  Set the affine transformation matrix for the main screen background 3
	*  to be the identity matrix. 1<<8 is 1 here because of fixed point arithmetic.
	*/
	REG_BG3PA = 1<< 8;
	REG_BG3PB = 0;
	REG_BG3PC = 0;
	REG_BG3PD = 1<< 8;

	/*  Place main screen background 3 at the origin (upper left of the
	*  screen).
	*/
	REG_BG3X = 0;
	REG_BG3Y = 0;

	
}


void displayStarField(){ 

	dmaCopyHalfWords(DMA_CHANNEL,
		starFieldBitmap, /* This variable is generated for us by
						 * grit. */
						 (uint16 *)BG_BMP_RAM(0), /* Our address for main
												  * background 3 */
												  starFieldBitmapLen); /* This length (in bytes) is generated
																	   * from grit. */

}
