#ifndef __RANDOM_DELAY_H
#define __RANDOM_DELAY_H

#include <iostream>

#include <chdl/chdl.h>
#include <chdl/ag.h>
#include <chdl/net.h>
#include <chdl/memreq.h>
#include <chdl/ingress.h>
#include <chdl/egress.h>


extern std::map<chdl::cycle_t, std::function<void()> > eq;
extern bool resp_valid, response_eaten;


template<typename T> void eq_sched(chdl::cycle_t t, T &f) {
  using namespace chdl;
  using namespace std;

  if (eq.count(t) == 0) {
    eq[t] = f;
  } else {
    cout << "Warning: event lost. Tried to schedule over existing event.";
  }
}

void advance_eq(chdl::cycle_t cyc);
bool can_sched(chdl::cycle_t t);

namespace chdl {
    
    template <unsigned SZ, unsigned T,
          unsigned B, unsigned N, unsigned A, unsigned I>
  class random_delay_mem : public delete_on_reset
          {
              public:
                  random_delay_mem(mem_resp<B, N, I> &resp, mem_req<B, N, A, I> &req, std::string filename="") {
                      if(filename == ""){
                          for (unsigned long i = 0; i < (1ull<<SZ); ++i)
                              for (unsigned j = 0; j < N; ++j)
                                  contents[i][j] = 0;
                      }else{

                          using namespace std;
                          //Vector for storing read values from dram image
                          vector<unsigned long long> init;
                          ifstream in(filename.c_str());
                          while (!!in) {
                              unsigned long long val;
                              in >> hex >> val;
                              if (!in) break;
                              init.push_back(val);
                          }

                          cout << "Read " << init.size() << " lines from memory image " << filename << endl;

                          unsigned long mem_lines;
                          mem_lines = (init.size() < (1ull<<SZ)) ? init.size() : (1ull<<SZ) ;

                          //Fill the initial region from the file

                          for (unsigned long i = 0; i < mem_lines; ++i){
                              unsigned long long val(init[i]);
                              for (unsigned j = 0; j < N; ++j) {
                                  contents[i][j] = val & ((1<<B) - 1);
                                  val >>= B;
                              }
                          }

                          // Fill the rest with zeros

                          for (unsigned long i = mem_lines; i < (1ull<<SZ); ++i){
                              for (unsigned j = 0; j < N; ++j){
                                  contents[i][j] = 0;
                              }
                          }
                      }


                      _(req, "ready") = _(resp, "ready");

                      Egress(resp_ready, _(resp, "ready"));
                      Egress(req_wr, _(_(req, "contents"), "wr"));
                      for (unsigned i = 0; i < N; ++i) {
                          Egress(req_mask[i], _(_(req, "contents"), "mask")[i]);
                          EgressInt(req_d[i], _(_(req, "contents"), "data")[i]);
                          _(_(resp, "contents"), "data")[i] = IngressInt<B>(resp_q[i]);
                      }
                      _(_(resp, "contents"), "wr") = resp_wr;
                      _(resp, "valid") = Ingress(resp_valid);
                      EgressInt(req_addr, _(_(req, "contents"), "addr"));
                      EgressInt(req_id, _(_(req, "contents"), "id"));
                      _(_(resp, "contents"), "id") = IngressInt<I>(resp_id);

                      EgressFunc([this](bool x){
                              if (x) {
                              do_req(req_wr);
                              }
                              }, _(req, "valid") && _(req, "ready"));

                      node eaten(_(resp, "ready") && _(resp, "valid")); TAP(eaten);
                      Egress(response_eaten, _(resp, "ready") && _(resp, "valid"));
                  }

                  bool req_mask[N], req_wr, resp_wr, resp_ready;
                  unsigned long req_addr;
                  unsigned req_id, resp_id;
                  unsigned long req_d[N], resp_q[N];
                  unsigned long contents[1<<SZ][N];

                  struct respval {
                      bool wr;
                      unsigned long q[N];
                      unsigned id;
                  };

                  cycle_t resp_time() { 
                      unsigned long long rand_val = rand();
                      return sim_time() + (rand_val % T) + 1; 
                  }

                  void do_req(bool wr) {
                      respval v;

                      if (wr) {
                          for (unsigned i = 0; i < N; ++i) {
                              if (req_mask[i]) contents[req_addr][i] = req_d[i];
                          }
                          v.wr = true;
                      } else {
                          for (unsigned i = 0; i < N; ++i) {
                              v.q[i] = contents[req_addr][i];
                          }
                          v.wr = false;
                      }
                      v.id = req_id;

                      cycle_t t(resp_time());
                      while (!can_sched(t)) ++t;
       

                      std::function<void()> action = [v, this]()
                      {
                          resp_valid = true;
                          resp_id = v.id;
                          if (!v.wr)
                              for (unsigned i = 0; i < N; ++i){
                                  resp_q[i] = v.q[i];
                              }
                      };

                      eq_sched(t, action);
                  }
          };

/*
template<unsigned SZ, unsigned T,
         unsigned B, unsigned N, unsigned A, unsigned I>
  void RandomDelayMem(mem_resp<B, N, I> &resp, mem_req<B, N, A, I> &req)
{
  new random_delay_mem<SZ,T,B,N,A,I>(resp, req);
}

*/

template<unsigned SZ, unsigned T,
         unsigned B, unsigned N, unsigned A, unsigned I>
  void RandomDelayMem(mem_resp<B, N, I> &resp, mem_req<B, N, A, I> &req, std::string filename)
{
    new random_delay_mem<SZ,T,B,N,A,I>(resp, req, filename);
}

};

#endif
