#include <cstdlib>
#include <iostream>
#include <stack>
#include <map>
#include <set>
#include <functional>

#include <chdl/memreq.h>
#include <chdl/lfsr.h>

#include <chdl/chdl.h>
#include <chdl/cassign.h>
#include <chdl/ingress.h>
#include <chdl/egress.h>
#include <chdl/reset.h>

using namespace std;
using namespace chdl;

bool response_eaten(0), resp_valid(0);
map<cycle_t, function<void()> > eq;
void advance_eq(cycle_t cyc) {
  if (response_eaten && eq.size() > 0) { eq.erase(eq.begin()); resp_valid = 0; }
  if (eq.size() > 0 && eq.begin()->first <= cyc) {
    eq.begin()->second();
  }
}

bool can_sched(cycle_t t) { return !eq.count(t); }

// When we call reset, we should remove any remaining events.
static void clear_eq() { eq.clear(); }
CHDL_REGISTER_RESET(clear_eq);

