/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import java.io.Serializable;
import java.text.DecimalFormat;
import shared.Copyable;
import util.linalg.DenseVector;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;

public abstract class Vector
implements Serializable,
Copyable {
    public abstract int size();

    public abstract double get(int var1);

    public Vector get(int ia, int ib) {
        double[] result = new double[ib - ia];
        int i = 0;
        while (i < result.length) {
            result[i] = this.get(ia + i);
            ++i;
        }
        return new DenseVector(result);
    }

    public void set(int i, Vector values) {
        int row = i;
        while (row - i < values.size()) {
            this.set(row, values.get(row - i));
            ++row;
        }
    }

    public abstract void set(int var1, double var2);

    public Vector max(Vector v) {
        double[] result = new double[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = Math.max(this.get(i), v.get(i));
            ++i;
        }
        return new DenseVector(result);
    }

    public void maxEquals(Vector v) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, Math.max(this.get(i), v.get(i)));
            ++i;
        }
    }

    public void minEquals(Vector v) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, Math.min(this.get(i), v.get(i)));
            ++i;
        }
    }

    public Vector min(Vector v) {
        double[] result = new double[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = Math.min(this.get(i), v.get(i));
            ++i;
        }
        return new DenseVector(result);
    }

    public int argMax() {
        int max = 0;
        int i = 1;
        while (i < this.size()) {
            if (this.get(i) > this.get(max)) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    public double dotProduct(Vector vector) {
        double result = 0.0;
        int i = 0;
        while (i < this.size()) {
            result += this.get(i) * vector.get(i);
            ++i;
        }
        return result;
    }

    public Matrix outerProduct(Vector vector) {
        double[][] result = new double[this.size()][this.size()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = this.get(i) * vector.get(j);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public Vector times(double scale) {
        Vector result = (Vector)this.copy();
        result.timesEquals(scale);
        return result;
    }

    public void timesEquals(double scale) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, this.get(i) * scale);
            ++i;
        }
    }

    public Vector plus(Vector vector) {
        Vector result = (Vector)this.copy();
        result.plusEquals(vector);
        return result;
    }

    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size()) {
            sum += this.get(i);
            ++i;
        }
        return sum;
    }

    public void plusEquals(Vector vector) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, this.get(i) + vector.get(i));
            ++i;
        }
    }

    public Vector minus(Vector vector) {
        Vector result = (Vector)this.copy();
        result.minusEquals(vector);
        return result;
    }

    public void minusEquals(Vector vector) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, this.get(i) - vector.get(i));
            ++i;
        }
    }

    public double normSquared() {
        return this.dotProduct(this);
    }

    public double norm() {
        return Math.sqrt(this.normSquared());
    }

    public Copyable copy() {
        double[] copy = new double[this.size()];
        int i = 0;
        while (i < copy.length) {
            copy[i] = this.get(i);
            ++i;
        }
        return new DenseVector(copy);
    }

    public boolean equals(Object o) {
        Vector v = (Vector)o;
        if (v.size() != this.size()) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            if (this.get(i) != v.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.000000");
        String result = "";
        int i = 0;
        while (i < this.size()) {
            result = String.valueOf(result) + df.format(this.get(i));
            if (i + 1 < this.size()) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        return result;
    }
}

