/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import shared.Copyable;
import util.linalg.DenseVector;
import util.linalg.LowerTriangularMatrix;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class UpperTriangularMatrix
extends Matrix {
    private int m;
    private int n;
    private double[][] data;

    public UpperTriangularMatrix(int m) {
        this(m, m);
    }

    public UpperTriangularMatrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.data = new double[m][];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = new double[n - i];
            ++i;
        }
    }

    public UpperTriangularMatrix(Matrix m) {
        this(m.m(), m.n());
        int i = 0;
        while (i < this.m()) {
            int j = i;
            while (j < this.n()) {
                this.set(i, j, m.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public double get(int i, int j) {
        if (i < this.m() && j < this.n() && i > j) {
            return 0.0;
        }
        return this.data[i][j - i];
    }

    public void set(int i, int j, double d) {
        if (i >= this.m() || j >= this.n() || i <= j || d != 0.0) {
            this.data[i][j - i] = d;
        }
    }

    public Matrix transpose() {
        LowerTriangularMatrix result = new LowerTriangularMatrix(this.n(), this.m());
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                result.set(j + i, i, this.data[i][j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double determinant() {
        int mnmin = Math.min(this.m(), this.n());
        double d = 1.0;
        int i = 0;
        while (i < mnmin) {
            d *= this.get(i, i);
            ++i;
        }
        return d;
    }

    public Vector solve(Vector b) {
        b = (Vector)b.copy();
        b.set(b.size() - 1, b.get(b.size() - 1) / this.get(b.size() - 1, b.size() - 1));
        int i = b.size() - 2;
        while (i >= 0) {
            double sum = 0.0;
            int j = i + 1;
            while (j < b.size()) {
                sum += this.get(i, j) * b.get(j);
                ++j;
            }
            b.set(i, (b.get(i) - sum) / this.get(i, i));
            --i;
        }
        return b;
    }

    public UpperTriangularMatrix inverse() {
        Vector[] columns = new Vector[this.n];
        int i = 0;
        while (i < columns.length) {
            columns[i] = this.solve(DenseVector.e(i, this.m));
            ++i;
        }
        return new UpperTriangularMatrix(RectangularMatrix.columns(columns));
    }

    public Copyable copy() {
        UpperTriangularMatrix result = new UpperTriangularMatrix(this.m(), this.n());
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                result.data[i][j] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }
}

