/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.DenseVector;
import util.linalg.HouseholderReflection;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class TridiagonalDecomposition {
    private RectangularMatrix t;
    private RectangularMatrix u;

    public TridiagonalDecomposition(Matrix a) {
        this.t = new RectangularMatrix((Matrix)a.copy());
        this.u = RectangularMatrix.eye(a.n());
        this.decompose();
    }

    private void decompose() {
        int i = 0;
        while (i < this.t.n() - 2) {
            Vector c = this.t.getColumn(i);
            Vector x = c.get(i + 1, c.size());
            HouseholderReflection hr = new HouseholderReflection(x);
            Vector v = hr.getV();
            double beta = hr.getBeta();
            DenseVector w = new DenseVector(v.size() + 1);
            int row = i;
            while (row < this.t.n()) {
                int column = i + 1;
                while (column < this.t.n()) {
                    ((Vector)w).set(row - i, ((Vector)w).get(row - i) + this.t.get(row, column) * v.get(column - (i + 1)));
                    ++column;
                }
                ((Vector)w).set(row - i, ((Vector)w).get(row - i) * beta);
                ++row;
            }
            Vector z = w.get(1, ((Vector)w).size());
            z = z.minus(v.times(beta * z.dotProduct(v) / 2.0));
            int row2 = i;
            while (row2 < this.t.n()) {
                int column = i;
                while (column < this.t.n()) {
                    if (row2 > i && column > i) {
                        this.t.set(row2, column, this.t.get(row2, column) - v.get(row2 - (i + 1)) * z.get(column - (i + 1)) - v.get(column - (i + 1)) * z.get(row2 - (i + 1)));
                    } else if (row2 > i) {
                        this.t.set(row2, column, this.t.get(row2, column) - v.get(row2 - (i + 1)) * ((Vector)w).get(column - i));
                    } else if (column > i) {
                        this.t.set(row2, column, this.t.get(row2, column) - v.get(column - (i + 1)) * ((Vector)w).get(row2 - i));
                    }
                    ++column;
                }
                ++row2;
            }
            hr.applyRight(this.u, 0, this.u.m(), i + 1, this.u.n());
            ++i;
        }
    }

    public RectangularMatrix getT() {
        return this.t;
    }

    public RectangularMatrix getU() {
        return this.u;
    }
}

