/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.DiagonalMatrix;
import util.linalg.GivensRotation;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.TridiagonalDecomposition;

public class SymmetricEigenvalueDecomposition {
    private static final double ERROR = 1.0E-10;
    private DiagonalMatrix d;
    private RectangularMatrix u;

    public SymmetricEigenvalueDecomposition(Matrix a) {
        TridiagonalDecomposition td = new TridiagonalDecomposition(a);
        this.u = td.getU();
        this.decompose(td.getT());
    }

    private void decompose(RectangularMatrix d) {
        int q = d.n();
        int p = 0;
        while (q > p + 1) {
            int i = 0;
            while (i < d.n() - 1) {
                if (Math.abs(d.get(i, i + 1)) < 1.0E-10) {
                    d.set(i, i + 1, 0.0);
                    d.set(i + 1, i, 0.0);
                }
                ++i;
            }
            q -= 2;
            while (q >= 0 && d.get(q, q + 1) == 0.0) {
                --q;
            }
            p = (q += 2) - 2;
            while (p >= 0 && d.get(p, p + 1) != 0.0) {
                --p;
            }
            if (q <= ++p + 1) continue;
            this.qrstep(d, p, q);
        }
        this.u = (RectangularMatrix)this.u.transpose();
        boolean swapped = true;
        RectangularMatrix u = this.u;
        int i = 0;
        while (i < u.m() - 1 && swapped) {
            swapped = false;
            int j = 0;
            while (j < u.m() - 1) {
                if (d.get(j, j) < d.get(j + 1, j + 1)) {
                    swapped = true;
                    double t = d.get(j, j);
                    d.set(j, j, d.get(j + 1, j + 1));
                    d.set(j + 1, j + 1, t);
                    double[] ta = u.getData()[j];
                    u.getData()[j] = u.getData()[j + 1];
                    u.getData()[j + 1] = ta;
                }
                ++j;
            }
            ++i;
        }
        this.u = (RectangularMatrix)u.transpose();
        this.d = new DiagonalMatrix(d);
    }

    private void qrstep(RectangularMatrix d, int ia, int ib) {
        double dd = (d.get(ib - 2, ib - 2) - d.get(ib - 1, ib - 1)) / 2.0;
        double signD = dd < 0.0 ? -1 : 1;
        double mu = d.get(ib - 1, ib - 1) - d.get(ib - 1, ib - 2) * d.get(ib - 1, ib - 2) / (dd + signD * Math.sqrt(dd * dd + d.get(ib - 1, ib - 2) * d.get(ib - 1, ib - 2)));
        double y = d.get(ia, ia) - mu;
        double z = d.get(ia + 1, ia);
        int i = ia;
        while (i < ib - 1) {
            GivensRotation g = new GivensRotation(y, z);
            g.applyRight(d, i, i + 1);
            g.applyLeft(d, i, i + 1);
            g.applyRight(this.u, i, i + 1);
            if (i + 1 < ib - 1) {
                y = d.get(i + 1, i);
                z = d.get(i + 2, i);
            }
            ++i;
        }
    }

    public DiagonalMatrix getD() {
        return this.d;
    }

    public RectangularMatrix getU() {
        return this.u;
    }
}

