/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.BidiagonalDecomposition;
import util.linalg.DenseVector;
import util.linalg.DiagonalMatrix;
import util.linalg.GivensRotation;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class SingularValueDecomposition {
    private static final double ERROR = 1.0E-10;
    private DiagonalMatrix d;
    private RectangularMatrix u;
    private RectangularMatrix v;

    public SingularValueDecomposition(Matrix a) {
        BidiagonalDecomposition bd = new BidiagonalDecomposition(a);
        this.v = bd.getV();
        this.u = (RectangularMatrix)bd.getU().transpose();
        this.decompose(bd.getB());
    }

    private void decompose(RectangularMatrix d) {
        int i;
        int mnmin;
        int q = mnmin = Math.min(d.m(), d.n());
        int p = 0;
        while (q > p + 1) {
            int i2 = 0;
            while (i2 < mnmin - 1) {
                if (Math.abs(d.get(i2, i2 + 1)) < 1.0E-10) {
                    d.set(i2, i2 + 1, 0.0);
                }
                ++i2;
            }
            q -= 2;
            while (q >= 0 && d.get(q, q + 1) == 0.0) {
                --q;
            }
            p = (q += 2) - 2;
            while (p >= 0 && d.get(p, p + 1) != 0.0) {
                --p;
            }
            if (q <= ++p + 1) continue;
            boolean zeroed = false;
            i = p;
            while (i < q - 1) {
                if (Math.abs(d.get(i, i)) < 1.0E-10) {
                    d.set(i, i + 1, 0.0);
                    zeroed = true;
                }
                ++i;
            }
            if (zeroed) continue;
            this.qrstep(d, p, q);
        }
        this.v = (RectangularMatrix)this.v.transpose();
        boolean swapped = true;
        i = 0;
        while (i < mnmin - 1 && swapped) {
            swapped = false;
            int j = 0;
            while (j < mnmin - 1) {
                if (d.get(j, j) < d.get(j + 1, j + 1)) {
                    swapped = true;
                    double t = d.get(j, j);
                    d.set(j, j, d.get(j + 1, j + 1));
                    d.set(j + 1, j + 1, t);
                    double[] ta = this.v.getData()[j];
                    this.v.getData()[j] = this.v.getData()[j + 1];
                    this.v.getData()[j + 1] = ta;
                    ta = this.u.getData()[j];
                    this.u.getData()[j] = this.u.getData()[j + 1];
                    this.u.getData()[j + 1] = ta;
                }
                ++j;
            }
            ++i;
        }
        this.u = (RectangularMatrix)this.u.transpose();
        this.v = (RectangularMatrix)this.v.transpose();
        this.d = new DiagonalMatrix(d);
    }

    private void qrstep(RectangularMatrix d, int ia, int ib) {
        double mu = d.get(ib - 1, ib - 1) * d.get(ib - 1, ib - 1) + d.get(ib - 1, ib - 2) * d.get(ib - 1, ib - 2);
        double y = d.get(ia, ia) * d.get(ia, ia) - mu;
        double z = d.get(ia, ia) * d.get(ia, ia + 1);
        int i = ia;
        while (i < ib - 1) {
            GivensRotation g = new GivensRotation(y, z);
            g.applyRight(d, i, i + 1);
            g.applyRight(this.v, i, i + 1);
            y = d.get(i, i);
            z = d.get(i + 1, i);
            g = new GivensRotation(y, z);
            g.applyLeft(d, i, i + 1);
            g.applyLeft(this.u, i, i + 1);
            if (i + 1 < ib - 1) {
                y = d.get(i, i + 1);
                z = d.get(i, i + 2);
            }
            ++i;
        }
    }

    public DiagonalMatrix getD() {
        return this.d;
    }

    public RectangularMatrix getU() {
        return this.u;
    }

    public RectangularMatrix getV() {
        return this.v;
    }

    public Vector solve(Vector b) {
        double[] x = new double[this.v.m()];
        int i = 0;
        int mnmin = Math.min(this.d.m(), this.d.n());
        while (i < mnmin && Math.abs(this.d.get(i, i)) > 1.0E-10) {
            double scale = 0.0;
            int j = 0;
            while (j < this.u.m()) {
                scale += this.u.get(j, i) * b.get(j);
                ++j;
            }
            scale /= this.d.get(i, i);
            j = 0;
            while (j < x.length) {
                int n = j;
                x[n] = x[n] + this.v.get(j, i) * scale;
                ++j;
            }
            ++i;
        }
        return new DenseVector(x);
    }
}

