/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import dist.Distribution;
import util.linalg.Matrix;
import util.linalg.Vector;

public class RectangularMatrix
extends Matrix {
    private double[][] data;

    public RectangularMatrix(int m, int n) {
        this.data = new double[m][n];
    }

    public RectangularMatrix(double[][] data) {
        this.data = data;
    }

    public RectangularMatrix(Matrix m) {
        this.data = new double[m.m()][m.n()];
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                this.data[i][j] = m.get(i, j);
                ++j;
            }
            ++i;
        }
    }

    public int m() {
        return this.data.length;
    }

    public int n() {
        return this.data[0].length;
    }

    public double get(int i, int j) {
        return this.data[i][j];
    }

    public void set(int i, int j, double d) {
        this.data[i][j] = d;
    }

    public double[][] getData() {
        return this.data;
    }

    public static RectangularMatrix eye(int m) {
        return RectangularMatrix.eye(m, m);
    }

    public static RectangularMatrix eye(int m, int n) {
        double[][] result = new double[m][n];
        int i = 0;
        int j = 0;
        while (i < m && j < n) {
            result[i][j] = 1.0;
            ++i;
            ++j;
        }
        return new RectangularMatrix(result);
    }

    public static RectangularMatrix diag(Matrix[] matrices) {
        int m = 0;
        int n = 0;
        int i = 0;
        while (i < matrices.length) {
            m += matrices[i].m();
            n += matrices[i].n();
            ++i;
        }
        RectangularMatrix result = new RectangularMatrix(m, n);
        int row = 0;
        int column = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            result.set(row, column, matrices[i2]);
            row += matrices[i2].m();
            column += matrices[i2].n();
            ++i2;
        }
        return result;
    }

    public static RectangularMatrix ones(int m) {
        return RectangularMatrix.ones(m, m);
    }

    public static RectangularMatrix ones(int m, int n) {
        double[][] result = new double[m][n];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public static RectangularMatrix random(int m) {
        return RectangularMatrix.random(m, m);
    }

    public static RectangularMatrix random(int m, int n) {
        double[][] data = new double[m][n];
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                data[i][j] = Distribution.random.nextDouble();
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(data);
    }

    public static Matrix columns(Vector[] columns) {
        RectangularMatrix rm = new RectangularMatrix(columns[0].size(), columns.length);
        int i = 0;
        while (i < columns.length) {
            rm.setColumn(i, columns[i]);
            ++i;
        }
        return rm;
    }

    public static Matrix rows(Vector[] rows) {
        RectangularMatrix rm = new RectangularMatrix(rows.length, rows[0].size());
        int i = 0;
        while (i < rows.length) {
            rm.setRow(i, rows[i]);
            ++i;
        }
        return rm;
    }
}

