/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.DenseVector;
import util.linalg.GivensRotation;
import util.linalg.HessenbergDecomposition;
import util.linalg.HouseholderReflection;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;

public class RealSchurDecomposition {
    private static final double ERROR = 1.0E-10;
    private static final double ZERO = 1.0E-6;
    private RectangularMatrix u;
    private RectangularMatrix t;

    public RealSchurDecomposition(Matrix a) {
        HessenbergDecomposition hd = new HessenbergDecomposition(a);
        this.t = hd.getH();
        this.u = hd.getU();
        this.decompose();
    }

    private void decompose() {
        int q = this.t.n();
        int p = 0;
        while (q > p + 1) {
            int i = 1;
            while (i < this.t.n()) {
                if (Math.abs(this.t.get(i, i - 1)) < 1.0E-10) {
                    this.t.set(i, i - 1, 0.0);
                }
                ++i;
            }
            --q;
            while (q > 0) {
                double aTimesC;
                double b;
                if (this.t.get(q, q - 1) == 0.0) {
                    --q;
                    continue;
                }
                if ((q <= 1 || this.t.get(q - 1, q - 2) != 0.0) && q != 1 || !((b = this.t.get(q - 1, q - 1) + this.t.get(q, q)) * b - 4.0 * (aTimesC = this.t.get(q - 1, q - 1) * this.t.get(q, q) - this.t.get(q - 1, q) * this.t.get(q, q - 1)) < 0.0)) break;
                --q;
            }
            p = ++q - 1;
            while (p > 0 && this.t.get(p, p - 1) != 0.0) {
                --p;
            }
            if (q <= p + 1) continue;
            if (q >= p + 3) {
                this.qrstep(p, q);
                continue;
            }
            this.qrstepTwoByTwo(p);
        }
    }

    private void qrstepTwoByTwo(int ia) {
        double d = (this.t.get(ia, ia) - this.t.get(ia + 1, ia + 1)) / 2.0;
        double signD = d < 0.0 ? -1 : 1;
        double mu = this.t.get(ia + 1, ia + 1) - this.t.get(ia + 1, ia) * this.t.get(ia + 1, ia) / (d + signD * Math.sqrt(d * d + this.t.get(ia + 1, ia) * this.t.get(ia + 1, ia)));
        double x = this.t.get(ia, ia) - mu;
        double y = this.t.get(ia + 1, ia);
        GivensRotation gr = new GivensRotation(x, y);
        gr.applyLeft(this.t, ia, ia + 1);
        gr.applyRight(this.t, ia, ia + 1);
        gr.applyRight(this.u, ia, ia + 1);
    }

    private void qrstep(int ia, int ib) {
        double a = this.t.get(ib - 1, ib - 1) + this.t.get(ib - 2, ib - 2);
        double b = this.t.get(ib - 1, ib - 1) * this.t.get(ib - 2, ib - 2) + this.t.get(ib - 1, ib - 2) * this.t.get(ib - 2, ib - 1);
        double x = this.t.get(ia, ia) * this.t.get(ia, ia) + this.t.get(ia, ia + 1) * this.t.get(ia + 1, ia) - a * this.t.get(ia, ia) + b;
        double y = this.t.get(ia + 1, ia) * (this.t.get(ia, ia) + this.t.get(ia + 1, ia + 1) - a);
        double z = this.t.get(ia + 1, ia) * this.t.get(ia + 2, ia + 1);
        int i = ia - 1;
        while (i < ib - 3) {
            DenseVector v = new DenseVector(new double[]{x, y, z});
            HouseholderReflection hr = new HouseholderReflection(v);
            hr.applyLeft(this.t, i + 1, i + 4, Math.max(i, ia), this.t.n());
            hr.applyRight(this.t, 0, Math.min(i + 5, ib), i + 1, i + 4);
            hr.applyRight(this.u, 0, this.u.n(), i + 1, i + 4);
            x = this.t.get(i + 2, i + 1);
            y = this.t.get(i + 3, i + 1);
            if (i < ib - 4) {
                z = this.t.get(i + 4, i + 1);
            }
            ++i;
        }
        DenseVector v = new DenseVector(new double[]{x, y});
        HouseholderReflection hr = new HouseholderReflection(v);
        hr.applyLeft(this.t, ib - 2, ib, ib - 3, this.t.n());
        hr.applyRight(this.t, 0, ib, ib - 2, ib);
        hr.applyRight(this.u, 0, this.u.n(), ib - 2, ib);
    }

    public RectangularMatrix getT() {
        return this.t;
    }

    public RectangularMatrix getU() {
        return this.u;
    }
}

