/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.HouseholderReflection;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.UpperTriangularMatrix;
import util.linalg.Vector;

public class QRDecomposition {
    private RectangularMatrix q;
    private UpperTriangularMatrix r;

    public QRDecomposition(Matrix matrix) {
        this.q = RectangularMatrix.eye(matrix.m());
        this.decompose((Matrix)matrix.copy());
    }

    private void decompose(Matrix a) {
        int mnmin = Math.min(a.n(), a.m());
        if (a.m() > a.n()) {
            ++mnmin;
        }
        int i = 0;
        while (i < mnmin - 1) {
            Vector column = a.getColumn(i);
            Vector x = column.get(i, column.size());
            HouseholderReflection h = new HouseholderReflection(x);
            h.applyLeft(a, i, a.m(), i, a.n());
            h.applyRight(this.q, 0, this.q.m(), i, this.q.n());
            ++i;
        }
        this.r = new UpperTriangularMatrix(a);
    }

    public RectangularMatrix getQ() {
        return this.q;
    }

    public UpperTriangularMatrix getR() {
        return this.r;
    }
}

