/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import java.io.Serializable;
import java.text.DecimalFormat;
import shared.Copyable;
import util.linalg.DenseVector;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public abstract class Matrix
implements Serializable,
Copyable {
    public abstract int m();

    public abstract int n();

    public abstract double get(int var1, int var2);

    public Matrix get(int ia, int ib, int ja, int jb) {
        double[][] result = new double[ib - ia][jb - ja];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = this.get(ia + i, ja + j);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public abstract void set(int var1, int var2, double var3);

    public void set(int i, int j, Matrix matrix) {
        int row = i;
        while (row < matrix.m() + i) {
            int column = j;
            while (column < matrix.n() + j) {
                this.set(row, column, matrix.get(row - i, column - j));
                ++column;
            }
            ++row;
        }
    }

    public Matrix transpose() {
        double[][] result = new double[this.n()][this.m()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = this.get(j, i);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public Vector getColumn(int index) {
        double[] result = new double[this.m()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.get(i, index);
            ++i;
        }
        return new DenseVector(result);
    }

    public void setColumn(int index, Vector v) {
        int i = 0;
        while (i < v.size()) {
            this.set(i, index, v.get(i));
            ++i;
        }
    }

    public Vector getRow(int index) {
        double[] result = new double[this.n()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.get(index, i);
            ++i;
        }
        return new DenseVector(result);
    }

    public void setRow(int index, Vector v) {
        int i = 0;
        while (i < v.size()) {
            this.set(index, i, v.get(i));
            ++i;
        }
    }

    public Matrix times(Matrix matrix) {
        double[][] result = new double[this.m()][matrix.n()];
        int row = 0;
        while (row < result.length) {
            int column = 0;
            while (column < result[0].length) {
                int i = 0;
                while (i < this.n()) {
                    double[] dArray = result[row];
                    int n = column;
                    dArray[n] = dArray[n] + this.get(row, i) * matrix.get(i, column);
                    ++i;
                }
                ++column;
            }
            ++row;
        }
        return new RectangularMatrix(result);
    }

    public Vector times(Vector vector) {
        double[] result = new double[this.m()];
        int row = 0;
        while (row < result.length) {
            int i = 0;
            while (i < this.n()) {
                int n = row;
                result[n] = result[n] + this.get(row, i) * vector.get(i);
                ++i;
            }
            ++row;
        }
        return new DenseVector(result);
    }

    public Matrix times(double scale) {
        Matrix result = (Matrix)this.copy();
        result.timesEquals(scale);
        return result;
    }

    public void timesEquals(double scale) {
        int i = 0;
        while (i < this.m()) {
            int j = 0;
            while (j < this.n()) {
                this.set(i, j, this.get(i, j) * scale);
                ++j;
            }
            ++i;
        }
    }

    public Matrix plus(Matrix matrix) {
        double[][] result = new double[this.m()][this.n()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = this.get(i, j) + matrix.get(i, j);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public void plusEquals(Matrix matrix) {
        int i = 0;
        while (i < this.m()) {
            int j = 0;
            while (j < this.n()) {
                this.set(i, j, this.get(i, j) + matrix.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public Matrix minus(Matrix matrix) {
        double[][] result = new double[this.m()][this.n()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = this.get(i, j) - matrix.get(i, j);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public void minusEquals(Matrix matrix) {
        int i = 0;
        while (i < this.m()) {
            int j = 0;
            while (j < this.n()) {
                this.set(i, j, this.get(i, j) - matrix.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public Copyable copy() {
        double[][] result = new double[this.m()][this.n()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = this.get(i, j);
                ++j;
            }
            ++i;
        }
        return new RectangularMatrix(result);
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.000000");
        String result = "";
        int i = 0;
        while (i < this.m()) {
            int j = 0;
            while (j < this.n()) {
                result = String.valueOf(result) + df.format(this.get(i, j)) + "\t";
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }
}

