/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.LowerTriangularMatrix;
import util.linalg.Matrix;
import util.linalg.UpperTriangularMatrix;
import util.linalg.Vector;

public class LUDecomposition {
    private LowerTriangularMatrix l;
    private UpperTriangularMatrix u;

    public LUDecomposition(Matrix a) {
        this.decompose((Matrix)a.copy());
    }

    private void decompose(Matrix a) {
        int mnmin = Math.min(a.m(), a.n());
        int k = 0;
        while (k < mnmin) {
            double pivot = a.get(k, k);
            int i = k + 1;
            while (i < a.m()) {
                a.set(i, k, a.get(i, k) / pivot);
                ++i;
            }
            i = k + 1;
            while (i < a.m()) {
                int j = k + 1;
                while (j < a.n()) {
                    a.set(i, j, a.get(i, j) - a.get(i, k) * a.get(k, j));
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        this.l = new LowerTriangularMatrix(a.m(), mnmin);
        this.u = new UpperTriangularMatrix(mnmin, a.n());
        int i = 0;
        while (i < this.l.m()) {
            int j = Math.min(i, this.l.n() - 1);
            while (j >= 0) {
                if (i == j) {
                    this.l.set(i, j, 1.0);
                } else {
                    this.l.set(i, j, a.get(i, j));
                }
                --j;
            }
            ++i;
        }
        i = 0;
        while (i < this.u.m()) {
            int j = i;
            while (j < this.u.n()) {
                this.u.set(i, j, a.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public LowerTriangularMatrix getL() {
        return this.l;
    }

    public UpperTriangularMatrix getU() {
        return this.u;
    }

    public double determinant() {
        return this.u.determinant();
    }

    public Vector solve(Vector b) {
        Vector y = this.l.solve(b);
        return this.u.solve(y);
    }
}

