/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.DenseVector;
import util.linalg.Matrix;
import util.linalg.Vector;

public class HouseholderReflection {
    private Vector v;
    private double beta;

    public HouseholderReflection(Vector v, double beta) {
        this.v = v;
        this.beta = beta;
    }

    public HouseholderReflection(Vector x) {
        this.v = new DenseVector(x.size());
        Vector ex = x.get(1, x.size());
        double sigma = ex.dotProduct(ex);
        this.v.set(0, 1.0);
        this.v.set(1, ex);
        if (sigma == 0.0) {
            this.beta = 0.0;
        } else {
            double mu = Math.sqrt(x.get(0) * x.get(0) + sigma);
            if (x.get(0) <= 0.0) {
                this.v.set(0, x.get(0) - mu);
            } else {
                this.v.set(0, -sigma / (x.get(0) + mu));
            }
            this.beta = 2.0 * this.v.get(0) * this.v.get(0) / (sigma + this.v.get(0) * this.v.get(0));
            this.v.timesEquals(1.0 / this.v.get(0));
        }
    }

    public void applyLeft(Matrix m, int ia, int ib, int ja, int jb) {
        DenseVector w = new DenseVector(jb - ja);
        int column = ja;
        while (column < jb) {
            int row = ia;
            while (row < ib) {
                ((Vector)w).set(column - ja, ((Vector)w).get(column - ja) + m.get(row, column) * this.v.get(row - ia));
                ++row;
            }
            ((Vector)w).set(column - ja, ((Vector)w).get(column - ja) * this.beta);
            ++column;
        }
        int row = ia;
        while (row < ib) {
            int column2 = ja;
            while (column2 < jb) {
                m.set(row, column2, m.get(row, column2) - this.v.get(row - ia) * ((Vector)w).get(column2 - ja));
                ++column2;
            }
            ++row;
        }
    }

    public void applyRight(Matrix m, int ia, int ib, int ja, int jb) {
        int column;
        DenseVector w = new DenseVector(ib - ia);
        int row = ia;
        while (row < ib) {
            column = ja;
            while (column < jb) {
                ((Vector)w).set(row - ia, ((Vector)w).get(row - ia) + m.get(row, column) * this.v.get(column - ja));
                ++column;
            }
            ((Vector)w).set(row - ia, ((Vector)w).get(row - ia) * this.beta);
            ++row;
        }
        row = ia;
        while (row < ib) {
            column = ja;
            while (column < jb) {
                m.set(row, column, m.get(row, column) - ((Vector)w).get(row - ia) * this.v.get(column - ja));
                ++column;
            }
            ++row;
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public Vector getV() {
        return this.v;
    }
}

