/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.HouseholderReflection;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class HessenbergDecomposition {
    private RectangularMatrix u;
    private RectangularMatrix h;

    public HessenbergDecomposition(Matrix a) {
        this.h = new RectangularMatrix(a);
        this.u = RectangularMatrix.eye(a.m());
        this.decompose();
    }

    private void decompose() {
        int i = 0;
        while (i < this.h.n() - 2) {
            Vector c = this.h.getColumn(i);
            Vector v = c.get(i + 1, c.size());
            HouseholderReflection hr = new HouseholderReflection(v);
            hr.applyLeft(this.h, i + 1, this.h.m(), i, this.h.n());
            hr.applyRight(this.h, 0, this.h.m(), i + 1, this.h.n());
            hr.applyRight(this.u, 0, this.u.m(), i + 1, this.u.n());
            ++i;
        }
    }

    public RectangularMatrix getH() {
        return this.h;
    }

    public RectangularMatrix getU() {
        return this.u;
    }
}

