/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.Matrix;

public class GivensRotation {
    private double cosine;
    private double sine;

    public GivensRotation(double theta) {
        this.cosine = Math.cos(theta);
        this.sine = Math.sin(theta);
    }

    public GivensRotation(double a, double b) {
        if (b == 0.0) {
            this.cosine = 1.0;
            this.sine = 0.0;
        } else if (Math.abs(b) > Math.abs(a)) {
            double t = -a / b;
            this.sine = 1.0 / Math.sqrt(1.0 + t * t);
            this.cosine = this.sine * t;
        } else {
            double t = -b / a;
            this.cosine = 1.0 / Math.sqrt(1.0 + t * t);
            this.sine = this.cosine * t;
        }
    }

    public void applyLeft(Matrix m, int i, int j) {
        int k = 0;
        while (k < m.n()) {
            double vi = m.get(i, k);
            double vj = m.get(j, k);
            m.set(i, k, this.cosine * vi - this.sine * vj);
            m.set(j, k, this.sine * vi + this.cosine * vj);
            ++k;
        }
    }

    public void applyRight(Matrix m, int i, int j) {
        int k = 0;
        while (k < m.m()) {
            double vi = m.get(k, i);
            double vj = m.get(k, j);
            m.set(k, i, this.cosine * vi - this.sine * vj);
            m.set(k, j, this.sine * vi + this.cosine * vj);
            ++k;
        }
    }
}

