/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.Matrix;

public class DiagonalMatrix
extends Matrix {
    private int m;
    private int n;
    private double[] diagonal;

    public DiagonalMatrix(Matrix m) {
        this.m = m.m();
        this.n = m.n();
        this.diagonal = new double[Math.min(m.m(), m.n())];
        int i = 0;
        while (i < this.diagonal.length) {
            this.diagonal[i] = m.get(i, i);
            ++i;
        }
    }

    public DiagonalMatrix(int m, int n, double[] diagonal) {
        this.m = m;
        this.n = n;
        this.diagonal = diagonal;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public double get(int i, int j) {
        if (i == j && i < this.diagonal.length) {
            return this.diagonal[i];
        }
        if (i > this.m || j > this.n) {
            throw new UnsupportedOperationException();
        }
        return 0.0;
    }

    public void set(int i, int j, double d) {
        if (i == j && i < this.diagonal.length) {
            this.diagonal[i] = d;
        } else if (d != 0.0 || i > this.m || j > this.n) {
            throw new UnsupportedOperationException();
        }
    }

    public DiagonalMatrix inverse() {
        double[] newDiagonal = new double[this.diagonal.length];
        int i = 0;
        while (i < this.diagonal.length) {
            newDiagonal[i] = 1.0 / this.diagonal[i];
            ++i;
        }
        return new DiagonalMatrix(this.m, this.n, newDiagonal);
    }

    public DiagonalMatrix squareRoot() {
        double[] newDiagonal = new double[this.diagonal.length];
        int i = 0;
        while (i < this.diagonal.length) {
            newDiagonal[i] = Math.sqrt(this.diagonal[i]);
            ++i;
        }
        return new DiagonalMatrix(this.m, this.n, newDiagonal);
    }
}

