/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.LowerTriangularMatrix;
import util.linalg.Matrix;
import util.linalg.UpperTriangularMatrix;
import util.linalg.Vector;

public class CholeskyFactorization {
    private LowerTriangularMatrix l;
    private UpperTriangularMatrix lt;

    public CholeskyFactorization(Matrix a) {
        this.l = new LowerTriangularMatrix(a);
        this.decompose();
    }

    private void decompose() {
        int j = 0;
        while (j < this.l.n()) {
            this.l.set(j, j, Math.sqrt(this.l.get(j, j)));
            int i = j + 1;
            while (i < this.l.m()) {
                this.l.set(i, j, this.l.get(i, j) / this.l.get(j, j));
                ++i;
            }
            int jj = j + 1;
            while (jj < this.l.n()) {
                int ii = jj;
                while (ii < this.l.m()) {
                    this.l.set(ii, jj, this.l.get(ii, jj) - this.l.get(ii, j) * this.l.get(jj, j));
                    ++ii;
                }
                ++jj;
            }
            ++j;
        }
        this.lt = (UpperTriangularMatrix)this.l.transpose();
    }

    public LowerTriangularMatrix getL() {
        return this.l;
    }

    public UpperTriangularMatrix getLt() {
        return this.lt;
    }

    public double determinant() {
        double d = this.l.determinant();
        return d * d;
    }

    public Vector solve(Vector b) {
        Vector y = this.l.solve(b);
        return this.lt.solve(y);
    }
}

