/*
 * Decompiled with CFR 0.152.
 */
package util.linalg;

import util.linalg.GivensRotation;
import util.linalg.HouseholderReflection;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.Vector;

public class BidiagonalDecomposition {
    private RectangularMatrix u;
    private RectangularMatrix v;
    private RectangularMatrix b;

    public BidiagonalDecomposition(Matrix matrix) {
        this.b = new RectangularMatrix(matrix);
        this.u = RectangularMatrix.eye(this.b.m());
        this.v = RectangularMatrix.eye(this.b.n());
        this.decompose();
    }

    private void decompose() {
        int mnmin = Math.min(this.b.n(), this.b.m());
        int i = 0;
        while (i < mnmin) {
            HouseholderReflection h;
            Vector x;
            if (i < this.b.m() - 1) {
                Vector column = this.b.getColumn(i);
                x = column.get(i, column.size());
                h = new HouseholderReflection(x);
                h.applyLeft(this.b, i, this.b.m(), i, this.b.n());
                h.applyRight(this.u, 0, this.u.m(), i, this.u.n());
            }
            if (i < this.b.n() - 2) {
                Vector row = this.b.getRow(i);
                x = row.get(i + 1, row.size());
                h = new HouseholderReflection(x);
                h.applyRight(this.b, i, this.b.m(), i + 1, this.b.n());
                h.applyRight(this.v, 0, this.v.m(), i + 1, this.v.n());
            }
            ++i;
        }
        if (this.b.n() > this.b.m()) {
            i = this.b.m() - 1;
            while (i >= 0) {
                double x = this.b.get(i, i);
                double y = this.b.get(i, this.b.m());
                GivensRotation g = new GivensRotation(x, y);
                g.applyRight(this.b, i, this.b.m());
                g.applyRight(this.v, i, this.b.m());
                --i;
            }
        }
    }

    public RectangularMatrix getB() {
        return this.b;
    }

    public RectangularMatrix getU() {
        return this.u;
    }

    public RectangularMatrix getV() {
        return this.v;
    }
}

