/*
 * Decompiled with CFR 0.152.
 */
package util.graph;

import java.util.Arrays;
import util.graph.Edge;
import util.graph.Graph;
import util.graph.GraphTransformation;
import util.graph.WeightedEdge;

public class KruskalsMST
implements GraphTransformation {
    private int[] ranks;
    private int[] paths;

    public Graph transform(Graph g) {
        Object[] edges = g.getEdges().toArray(new WeightedEdge[0]);
        Arrays.sort(edges);
        int i = 0;
        while (i < g.getNodeCount()) {
            g.getNode(i).getEdges().clear();
            ++i;
        }
        this.ranks = new int[g.getNodeCount()];
        this.paths = new int[g.getNodeCount()];
        i = 0;
        while (i < g.getNodeCount()) {
            this.ranks[i] = 0;
            this.paths[i] = i;
            ++i;
        }
        i = 0;
        while (i < edges.length) {
            int in = ((Edge)edges[i]).getA().getLabel();
            int out = ((Edge)edges[i]).getB().getLabel();
            if (this.set(in) != this.set(out)) {
                this.combine(in, out);
                g.getNode(in).connect(g.getNode(out), (Edge)edges[i]);
            }
            ++i;
        }
        this.ranks = null;
        this.paths = null;
        return g;
    }

    private int set(int i) {
        if (this.paths[i] != i) {
            this.paths[i] = this.set(this.paths[i]);
        }
        return this.paths[i];
    }

    private void combine(int i, int j) {
        this.link(this.set(i), this.set(j));
    }

    private void link(int i, int j) {
        if (this.ranks[i] > this.ranks[j]) {
            this.paths[j] = i;
        } else {
            this.paths[i] = j;
            if (this.ranks[i] == this.ranks[j]) {
                int n = j;
                this.ranks[n] = this.ranks[n] + 1;
            }
        }
    }
}

