/*
 * Decompiled with CFR 0.152.
 */
package util.graph;

import util.graph.Edge;
import util.graph.Graph;
import util.graph.GraphTransformation;
import util.graph.Node;
import util.graph.Tree;

public class DFSTree
implements GraphTransformation {
    boolean[] visited;

    public Graph transform(Graph g) {
        this.visited = new boolean[g.getNodeCount()];
        int i = 0;
        while (i < this.visited.length) {
            this.visited[i] = false;
            ++i;
        }
        this.dfs(g.getNode(0));
        Tree result = new Tree(g.getNode(0));
        result.setNodes(g.getNodes());
        this.visited = null;
        return result;
    }

    private void dfs(Node n) {
        this.visited[n.getLabel()] = true;
        int i = 0;
        while (i < n.getEdgeCount()) {
            Edge edge = n.getEdge(i);
            Node other = edge.getOther(n);
            if (this.visited[other.getLabel()]) {
                n.removeEdge(i);
                --i;
            } else {
                this.dfs(other);
            }
            ++i;
        }
    }
}

