/*
 * Decompiled with CFR 0.152.
 */
package util;

public class MaxHeap {
    private HeapItem[] items;
    private int size;

    public MaxHeap(int capacity) {
        this.items = new HeapItem[capacity + 1];
    }

    public void add(Object o, double priority) {
        if (this.size + 1 >= this.items.length) {
            HeapItem[] oldItems = this.items;
            this.items = new HeapItem[oldItems.length * 2];
            System.arraycopy(oldItems, 0, this.items, 0, oldItems.length);
        }
        ++this.size;
        this.items[this.size] = new HeapItem(o, priority);
        int i = this.size;
        while (i > 1 && this.items[this.parent(i)].priority < this.items[i].priority) {
            HeapItem temp = this.items[i];
            this.items[i] = this.items[this.parent(i)];
            this.items[this.parent((int)i)] = temp;
            i = this.parent(i);
        }
    }

    public Object extractMax() {
        HeapItem item = this.items[1];
        this.items[1] = this.items[this.size];
        --this.size;
        this.heapify(1);
        return item.object;
    }

    private void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int largest = i;
        if (l <= this.size && this.items[l].priority > this.items[largest].priority) {
            largest = l;
        }
        if (r <= this.size && this.items[r].priority > this.items[largest].priority) {
            largest = r;
        }
        if (largest != i) {
            HeapItem temp = this.items[i];
            this.items[i] = this.items[largest];
            this.items[largest] = temp;
            this.heapify(largest);
        }
    }

    private int left(int i) {
        return 2 * i;
    }

    private int right(int i) {
        return 2 * i + 1;
    }

    private int parent(int i) {
        return i / 2;
    }

    public Object getMaxObject() {
        HeapItem item = this.items[1];
        return item.object;
    }

    public double getMaxKey() {
        return this.items[1].priority;
    }

    public int size() {
        return this.size;
    }

    public Object[] getData() {
        Object[] data = new Object[this.size];
        int i = 1;
        while (i <= this.size) {
            data[i - 1] = this.items[i].object;
            ++i;
        }
        return data;
    }

    private class HeapItem {
        private Object object;
        private double priority;

        public HeapItem(Object item, double priority) {
            this.object = item;
            this.priority = priority;
        }
    }
}

