/*
 * Decompiled with CFR 0.152.
 */
package shared.filt.ica;

import shared.filt.ica.ContrastFunction;

public class HyperbolicTangentContrast
implements ContrastFunction {
    public double g(double value) {
        double e2x = Math.exp(2.0 * value);
        if (e2x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return (e2x - 1.0) / (e2x + 1.0);
    }

    public double gprime(double value) {
        double tanhvalue = this.g(value);
        return 1.0 - tanhvalue * tanhvalue;
    }
}

