/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import shared.DataSet;
import shared.Instance;
import shared.filt.ReversibleFilter;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.SingularValueDecomposition;

public class RandomizedProjectionFilter
implements ReversibleFilter {
    private Matrix projection;

    public RandomizedProjectionFilter(int componentsOut, int componentsIn) {
        this.projection = RectangularMatrix.random(componentsOut, componentsIn);
        this.projection.minusEquals(RectangularMatrix.ones(this.projection.m(), this.projection.n()).times(0.5));
        SingularValueDecomposition svd = new SingularValueDecomposition(this.projection);
        this.projection = componentsIn <= componentsOut ? svd.getU().get(0, this.projection.m(), 0, this.projection.n()) : svd.getV().get(0, this.projection.m(), 0, this.projection.n());
    }

    public void filter(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.projection.times(instance.getData()));
            ++i;
        }
    }

    public void reverse(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.projection.transpose().times(instance.getData()));
            ++i;
        }
    }

    public Matrix getProjection() {
        return this.projection;
    }
}

