/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import dist.MultivariateGaussian;
import shared.DataSet;
import shared.Instance;
import shared.filt.ReversibleFilter;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.SymmetricEigenvalueDecomposition;
import util.linalg.Vector;

public class PrincipalComponentAnalysis
implements ReversibleFilter {
    private static final double THRESHOLD = 1.0E-6;
    private Matrix projection;
    private Matrix eigenValues;
    private Vector mean;

    public PrincipalComponentAnalysis(DataSet dataSet, int toKeep, double threshold) {
        MultivariateGaussian mg = new MultivariateGaussian();
        mg.estimate(dataSet);
        Matrix covarianceMatrix = mg.getCovarianceMatrix();
        this.mean = mg.getMean();
        if (toKeep == -1) {
            toKeep = this.mean.size();
        }
        SymmetricEigenvalueDecomposition sed = new SymmetricEigenvalueDecomposition(covarianceMatrix);
        RectangularMatrix eigenVectors = sed.getU();
        this.eigenValues = sed.getD();
        int aboveThreshold = 0;
        while (aboveThreshold < toKeep && this.eigenValues.get(aboveThreshold, aboveThreshold) > threshold) {
            ++aboveThreshold;
        }
        toKeep = Math.min(toKeep, aboveThreshold);
        this.projection = new RectangularMatrix(toKeep, ((Matrix)eigenVectors).m());
        int i = 0;
        while (i < toKeep) {
            this.projection.setRow(i, eigenVectors.getColumn(i));
            ++i;
        }
    }

    public PrincipalComponentAnalysis(DataSet set, int numberOfComponents) {
        this(set, numberOfComponents, 1.0E-6);
    }

    public PrincipalComponentAnalysis(DataSet set) {
        this(set, -1);
    }

    public void filter(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(instance.getData().minus(this.mean));
            instance.setData(this.projection.times(instance.getData()));
            ++i;
        }
        dataSet.setDescription(null);
    }

    public void reverse(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.projection.transpose().times(instance.getData()));
            instance.setData(instance.getData().plus(this.mean));
            ++i;
        }
        dataSet.setDescription(null);
    }

    public Matrix getProjection() {
        return this.projection;
    }

    public Vector getMean() {
        return this.mean;
    }

    public Matrix getEigenValues() {
        return this.eigenValues;
    }
}

