/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import dist.MultivariateGaussian;
import shared.DataSet;
import shared.Instance;
import shared.filt.ReversibleFilter;
import util.linalg.Matrix;
import util.linalg.RectangularMatrix;
import util.linalg.SymmetricEigenvalueDecomposition;
import util.linalg.Vector;

public class InsignificantComponentAnalysis
implements ReversibleFilter {
    private static final double THRESHOLD = Double.MAX_VALUE;
    private Matrix projection;
    private Matrix eigenValues;
    private Vector mean;

    public InsignificantComponentAnalysis(DataSet dataSet, int toKeep, double threshold) {
        MultivariateGaussian mg = new MultivariateGaussian();
        mg.estimate(dataSet);
        Matrix covarianceMatrix = mg.getCovarianceMatrix();
        this.mean = mg.getMean();
        if (toKeep == -1) {
            toKeep = this.mean.size();
        }
        SymmetricEigenvalueDecomposition sed = new SymmetricEigenvalueDecomposition(covarianceMatrix);
        RectangularMatrix eigenVectors = sed.getU();
        this.eigenValues = sed.getD();
        int belowThreshold = 0;
        while (belowThreshold < toKeep && this.eigenValues.get(this.eigenValues.m() - belowThreshold - 1, this.eigenValues.m() - belowThreshold - 1) < threshold) {
            ++belowThreshold;
        }
        toKeep = Math.min(toKeep, belowThreshold);
        this.projection = new RectangularMatrix(toKeep, ((Matrix)eigenVectors).m());
        int i = ((Matrix)eigenVectors).m() - 1;
        while (((Matrix)eigenVectors).m() - i - 1 < toKeep) {
            this.projection.setRow(((Matrix)eigenVectors).m() - i - 1, eigenVectors.getColumn(i));
            --i;
        }
    }

    public InsignificantComponentAnalysis(DataSet set, int numberOfComponents) {
        this(set, numberOfComponents, Double.MAX_VALUE);
    }

    public InsignificantComponentAnalysis(DataSet set) {
        this(set, -1);
    }

    public void filter(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(instance.getData().minus(this.mean));
            instance.setData(this.projection.times(instance.getData()));
            ++i;
        }
        dataSet.setDescription(null);
    }

    public void reverse(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.projection.transpose().times(instance.getData()));
            instance.setData(instance.getData().plus(this.mean));
            ++i;
        }
        dataSet.setDescription(null);
    }

    public Matrix getProjection() {
        return this.projection;
    }

    public Vector getMean() {
        return this.mean;
    }

    public Matrix getEigenValues() {
        return this.eigenValues;
    }
}

