/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import dist.MultivariateGaussian;
import shared.DataSet;
import shared.Instance;
import shared.filt.PrincipalComponentAnalysis;
import shared.filt.RandomizedProjectionFilter;
import shared.filt.ReversibleFilter;
import shared.filt.ica.ContrastFunction;
import shared.filt.ica.HyperbolicTangentContrast;
import util.linalg.DenseVector;
import util.linalg.DiagonalMatrix;
import util.linalg.Matrix;
import util.linalg.SymmetricEigenvalueDecomposition;
import util.linalg.Vector;

public class IndependentComponentAnalysis
implements ReversibleFilter {
    private Matrix projection;
    private Matrix reverseProjection;
    private PrincipalComponentAnalysis pca;

    public IndependentComponentAnalysis(DataSet dataSet) {
        this(dataSet, -1);
    }

    public IndependentComponentAnalysis(DataSet dataSet, int numberOfComponents) {
        this(dataSet, numberOfComponents, 1.0, new HyperbolicTangentContrast(), 1.0E-5, 1000);
    }

    public IndependentComponentAnalysis(DataSet dataSet, int numberOfComponents, double mu, ContrastFunction cf, double tolerance, int maxIterations) {
        Instance[] copy = new Instance[dataSet.size()];
        int i = 0;
        while (i < copy.length) {
            copy[i] = (Instance)dataSet.get(i).copy();
            ++i;
        }
        dataSet = new DataSet(copy);
        if (numberOfComponents == -1) {
            numberOfComponents = copy[0].size();
        }
        this.pca = new PrincipalComponentAnalysis(dataSet);
        this.pca.filter(dataSet);
        MultivariateGaussian mg = new MultivariateGaussian();
        mg.estimate(dataSet);
        DiagonalMatrix covarianceMatrix = new DiagonalMatrix(mg.getCovarianceMatrix());
        DiagonalMatrix whiteningMatrix = covarianceMatrix.inverse().squareRoot();
        DiagonalMatrix dewhiteningMatrix = covarianceMatrix.squareRoot();
        int i2 = 0;
        while (i2 < dataSet.size()) {
            Instance instance = dataSet.get(i2);
            instance.setData(whiteningMatrix.times(instance.getData()));
            ++i2;
        }
        RandomizedProjectionFilter rpf = new RandomizedProjectionFilter(whiteningMatrix.m(), numberOfComponents);
        Matrix w = rpf.getProjection();
        boolean done = false;
        int iterations = 0;
        while (!done && iterations < maxIterations) {
            Matrix oldW = (Matrix)w.copy();
            int i3 = 0;
            while (i3 < w.n()) {
                Vector wv = w.getColumn(i3);
                DenseVector exg = new DenseVector(wv.size());
                double egprime = 0.0;
                double beta = 0.0;
                int j = 0;
                while (j < dataSet.size()) {
                    Vector x = dataSet.get(j).getData();
                    double dotProduct = wv.dotProduct(x);
                    Vector xg = x.times(cf.g(dotProduct));
                    exg.plusEquals(xg);
                    egprime += cf.gprime(dotProduct);
                    beta += wv.dotProduct(xg);
                    ++j;
                }
                exg.timesEquals(1.0 / (double)dataSet.size());
                Vector dw = exg.minus(wv.times(beta *= 1.0 / (double)dataSet.size()));
                dw.timesEquals(-mu / ((egprime *= 1.0 / (double)dataSet.size()) - beta));
                wv.plusEquals(dw);
                wv.timesEquals(1.0 / wv.norm());
                w.setColumn(i3, wv);
                ++i3;
            }
            SymmetricEigenvalueDecomposition sed = new SymmetricEigenvalueDecomposition(w.transpose().times(w));
            w = w.times(sed.getU().times(sed.getD().inverse().squareRoot().times(sed.getU().transpose())));
            Matrix ones = oldW.transpose().times(w);
            double maxOff = 0.0;
            int i4 = 0;
            while (i4 < ones.m()) {
                maxOff = Math.max(maxOff, 1.0 - Math.abs(ones.get(i4, i4)));
                ++i4;
            }
            done = maxOff < tolerance;
            ++iterations;
        }
        this.projection = w.transpose().times(whiteningMatrix);
        this.reverseProjection = dewhiteningMatrix.times(w);
    }

    public void filter(DataSet dataSet) {
        this.pca.filter(dataSet);
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.projection.times(instance.getData()));
            ++i;
        }
    }

    public void reverse(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            instance.setData(this.reverseProjection.times(instance.getData()));
            ++i;
        }
        dataSet.setDescription(null);
        this.pca.reverse(dataSet);
    }

    public PrincipalComponentAnalysis getPCA() {
        return this.pca;
    }

    public Matrix getProjection() {
        return this.projection;
    }

    public Matrix getReverseProjection() {
        return this.reverseProjection;
    }
}

