/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import shared.AttributeType;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;
import shared.filt.DataSetFilter;
import util.linalg.DenseVector;

public class DiscreteToBinaryFilter
implements DataSetFilter {
    public void filter(DataSet dataSet) {
        if (dataSet.getDescription() == null) {
            dataSet.setDescription(new DataSetDescription(dataSet));
        }
        int newAttributeCount = 0;
        DataSetDescription oldDescription = dataSet.getDescription();
        int i = 0;
        while (i < oldDescription.getAttributeTypes().length) {
            newAttributeCount = oldDescription.getAttributeTypes()[i] == AttributeType.DISCRETE ? (newAttributeCount += oldDescription.getDiscreteRange(i)) : ++newAttributeCount;
            ++i;
        }
        if (newAttributeCount == oldDescription.getAttributeCount()) {
            return;
        }
        i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            int k = 0;
            double[] data = new double[newAttributeCount];
            int j = 0;
            while (j < oldDescription.getAttributeTypes().length) {
                if (oldDescription.getAttributeTypes()[j] == AttributeType.DISCRETE) {
                    data[k + instance.getDiscrete((int)j)] = 1.0;
                    k += oldDescription.getDiscreteRange(j);
                } else {
                    data[k] = instance.getContinuous(j);
                    ++k;
                }
                ++j;
            }
            instance.setData(new DenseVector(data));
            ++i;
        }
        dataSet.setDescription(null);
    }
}

