/*
 * Decompiled with CFR 0.152.
 */
package shared.filt;

import shared.AttributeType;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;
import shared.filt.DataSetFilter;

public class ContinuousToDiscreteFilter
implements DataSetFilter {
    private int numberOfBins;

    public ContinuousToDiscreteFilter(int numberOfBins) {
        this.numberOfBins = numberOfBins;
    }

    public void filter(DataSet dataSet) {
        if (dataSet.getDescription() == null) {
            dataSet.setDescription(new DataSetDescription(dataSet));
        }
        DataSetDescription oldDescription = dataSet.getDescription();
        int i = 0;
        while (i < dataSet.size()) {
            Instance instance = dataSet.get(i);
            int j = 0;
            while (j < oldDescription.getAttributeCount()) {
                if (oldDescription.getAttributeTypes()[j] == AttributeType.CONTINUOUS) {
                    double cv = instance.getContinuous(j);
                    int dv = (int)((cv - oldDescription.getMin(j)) * (double)this.numberOfBins / oldDescription.getRange(j));
                    instance.getData().set(j, dv);
                }
                ++j;
            }
            ++i;
        }
        dataSet.setDescription(null);
    }
}

