/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.Serializable;
import shared.Copyable;
import util.linalg.DenseVector;
import util.linalg.Vector;

public class Instance
implements Serializable,
Copyable {
    private Instance label;
    private Vector data;
    private double weight;

    public Instance(Vector data, Instance label, double weight) {
        this.data = data;
        this.label = label;
        this.weight = weight;
    }

    public Instance(Vector data, Instance label) {
        this.data = data;
        this.label = label;
        this.weight = 1.0;
    }

    public Instance(Vector v) {
        this.data = v;
        this.weight = 1.0;
    }

    public Instance(double[] ds) {
        this.data = new DenseVector(ds);
        this.weight = 1.0;
    }

    public Instance(double val) {
        this.data = new DenseVector(1);
        this.data.set(0, val);
        this.weight = 1.0;
    }

    public Instance(int val) {
        this.data = new DenseVector(1);
        this.data.set(0, val);
        this.weight = 1.0;
    }

    public Instance(int i, int o) {
        this(i);
        this.label = new Instance(o);
    }

    public Instance(double[] ds, int i) {
        this(ds);
        this.label = new Instance(i);
    }

    public Instance(double[] ds, boolean b) {
        this(ds);
        this.label = new Instance(b);
    }

    public Instance(boolean val) {
        this(val ? 1 : 0);
    }

    public int size() {
        return this.data.size();
    }

    public double getContinuous(int i) {
        return this.data.get(i);
    }

    public int getDiscrete(int i) {
        return (int)this.data.get(i);
    }

    public double getContinuous() {
        return this.getContinuous(0);
    }

    public int getDiscrete() {
        return this.getDiscrete(0);
    }

    public double getPlusMinus() {
        return this.getDiscrete() == 1 ? 1 : -1;
    }

    public boolean getBoolean() {
        return this.getDiscrete() == 1;
    }

    public Instance getLabel() {
        return this.label;
    }

    public Vector getData() {
        return this.data;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setData(Vector vector) {
        this.data = vector;
    }

    public void setLabel(Instance instance) {
        this.label = instance;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public Copyable copy() {
        if (this.label != null) {
            return new Instance((Vector)this.data.copy(), (Instance)this.label.copy(), this.weight);
        }
        return new Instance((Vector)this.data.copy(), null, this.weight);
    }

    public String toString() {
        String result = this.data.toString();
        if (this.label != null) {
            result = String.valueOf(result) + " : " + this.label.toString();
        }
        if (this.weight != 1.0) {
            result = String.valueOf(result) + " x " + this.weight;
        }
        return result;
    }
}

