/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import shared.DataSet;
import shared.DataSetDescription;
import shared.Instance;

public class DataSetReader {
    private String file;

    public DataSetReader(String file) {
        this.file = file;
    }

    public DataSet read() throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        ArrayList<Instance> data = new ArrayList<Instance>();
        Pattern pattern = Pattern.compile("[ ,]+");
        while ((line = br.readLine()) != null) {
            String[] split = pattern.split(line.trim());
            double[] input = new double[split.length];
            int i = 0;
            while (i < input.length) {
                input[i] = Double.parseDouble(split[i]);
                ++i;
            }
            Instance instance = new Instance(input);
            data.add(instance);
        }
        br.close();
        Instance[] instances = data.toArray(new Instance[0]);
        DataSet set = new DataSet(instances);
        set.setDescription(new DataSetDescription(set));
        return set;
    }
}

