/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.Serializable;
import java.util.Arrays;
import shared.AttributeType;
import shared.DataSet;
import shared.Instance;
import util.ABAGAILArrays;
import util.linalg.DenseVector;
import util.linalg.Vector;

public class DataSetDescription
implements Serializable {
    private DataSetDescription labelDescription;
    private AttributeType[] types;
    private Vector max;
    private Vector min;

    public DataSetDescription(AttributeType[] types, Vector min, Vector max, DataSetDescription labelDescription) {
        this.types = types;
        this.max = max;
        this.min = min;
        this.labelDescription = labelDescription;
    }

    public DataSetDescription(AttributeType[] types, Vector max, DataSetDescription labelDescription) {
        this(types, null, max, labelDescription);
        this.min = new DenseVector(max.size());
    }

    public DataSetDescription(AttributeType[] types, Vector max) {
        this(types, null, max, null);
    }

    public DataSetDescription(AttributeType[] types, Vector min, Vector max) {
        this(types, min, max, null);
    }

    public DataSetDescription() {
    }

    public DataSetDescription(DataSet dataSet) {
        this.induceFrom(dataSet);
    }

    public int getDiscreteRange(int i) {
        return (int)this.max.get(i) + 1;
    }

    public int getDiscreteRange() {
        return this.getDiscreteRange(0);
    }

    public double getRange(int i) {
        return this.getMax(i) - this.getMin(i);
    }

    public double getRange() {
        return this.getRange(0);
    }

    public double getMax(int i) {
        return this.max.get(i);
    }

    public double getMax() {
        return this.getMax(0);
    }

    public double getMin(int i) {
        return this.min.get(i);
    }

    public double getMin() {
        return this.getMin(0);
    }

    public DataSetDescription getLabelDescription() {
        return this.labelDescription;
    }

    public Vector getMaxVector() {
        return this.max;
    }

    public AttributeType[] getAttributeTypes() {
        return this.types;
    }

    public int getAttributeCount() {
        return this.types.length;
    }

    public Vector getMinVector() {
        return this.min;
    }

    public void setLabelDescription(DataSetDescription description) {
        this.labelDescription = description;
    }

    public void setMaxVector(Vector instance) {
        this.max = instance;
    }

    public void setMinVector(Vector instance) {
        this.min = instance;
    }

    public void setAttributeTypes(AttributeType[] types) {
        this.types = types;
    }

    public void induceFrom(DataSet data) {
        boolean hasLabels = false;
        int i = 0;
        while (data.get(i) == null) {
            ++i;
        }
        if (i >= data.size()) {
            return;
        }
        if (this.max == null) {
            this.max = (Vector)data.get(i).getData().copy();
        }
        if (this.min == null) {
            this.min = (Vector)data.get(i).getData().copy();
        }
        if (this.types == null) {
            this.types = new AttributeType[data.get(i).size()];
            Arrays.fill(this.types, AttributeType.BINARY);
        }
        while (i < data.size()) {
            Instance cur = data.get(i);
            if (cur != null) {
                hasLabels = hasLabels || cur.getLabel() != null;
                this.max.maxEquals(cur.getData());
                this.min.minEquals(cur.getData());
                int j = 0;
                while (j < this.types.length) {
                    if (this.types[j] == AttributeType.BINARY && cur.getContinuous(j) != 1.0 && cur.getContinuous(j) != 0.0) {
                        this.types[j] = AttributeType.DISCRETE;
                    }
                    if (this.types[j] == AttributeType.DISCRETE && (double)cur.getDiscrete(j) != cur.getContinuous(j)) {
                        this.types[j] = AttributeType.CONTINUOUS;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (hasLabels) {
            if (this.labelDescription == null) {
                this.labelDescription = new DataSetDescription();
            }
            this.labelDescription.induceFrom(data.getLabelDataSet());
        }
    }

    public String toString() {
        String result = "Types : " + ABAGAILArrays.toString(this.types);
        result = String.valueOf(result) + "\nMax : " + this.max;
        result = String.valueOf(result) + "\nMin : " + this.min;
        if (this.labelDescription != null) {
            result = String.valueOf(result) + "\nLabel Description:\n" + this.labelDescription;
        }
        return result;
    }
}

