/*
 * Decompiled with CFR 0.152.
 */
package shared;

import shared.Trainer;

public class ConvergenceTrainer
implements Trainer {
    private static final double THRESHOLD = 1.0E-10;
    private static final int MAX_ITERATIONS = 500;
    private Trainer trainer;
    private double threshold;
    private int iterations;
    private int maxIterations;

    public ConvergenceTrainer(Trainer trainer, double threshold, int maxIterations) {
        this.trainer = trainer;
        this.threshold = threshold;
        this.maxIterations = maxIterations;
    }

    public ConvergenceTrainer(Trainer trainer) {
        this(trainer, 1.0E-10, 500);
    }

    public double train() {
        double lastError;
        double error = Double.MAX_VALUE;
        do {
            ++this.iterations;
            lastError = error;
        } while (Math.abs((error = this.trainer.train()) - lastError) > this.threshold && this.iterations < this.maxIterations);
        return error;
    }

    public int getIterations() {
        return this.iterations;
    }
}

