/*
 * Decompiled with CFR 0.152.
 */
package rl;

import dist.Distribution;
import dist.UnivariateGaussian;
import dist.hmm.ModularHiddenMarkovModel;
import dist.hmm.SimpleStateDistribution;
import dist.hmm.SimpleStateDistributionTable;
import dist.hmm.StateDistribution;
import rl.MarkovDecisionProcess;
import shared.Instance;

public class SimpleMarkovDecisionProcess
extends ModularHiddenMarkovModel
implements MarkovDecisionProcess {
    public void setRewards(double[] rewardValues) {
        Distribution[] outputs = new Distribution[rewardValues.length];
        int i = 0;
        while (i < rewardValues.length) {
            outputs[i] = new UnivariateGaussian(rewardValues[i], 1.0);
            ++i;
        }
        this.setOutputDistributions(outputs);
    }

    public double[] getRewards() {
        double[] rewards = new double[this.getStateCount()];
        int i = 0;
        while (i < rewards.length) {
            rewards[i] = ((UnivariateGaussian)this.getOutputDistributions()[i]).getMean();
            ++i;
        }
        return rewards;
    }

    public double reward(int state, int action) {
        return ((UnivariateGaussian)this.getOutputDistributions()[state]).getMean();
    }

    public void setTransitionMatrices(double[][][] matrices) {
        StateDistribution[] transitions = new StateDistribution[matrices.length];
        int i = 0;
        while (i < matrices.length) {
            transitions[i] = new SimpleStateDistributionTable(matrices[i]);
            ++i;
        }
        this.setTransitionDistributions(transitions);
    }

    public double[][][] getTransitionMatrices() {
        double[][][] matrices = new double[this.getStateCount()][][];
        int i = 0;
        while (i < matrices.length) {
            matrices[i] = ((SimpleStateDistributionTable)this.getTransitionDistributions()[i]).getProbabilityMatrix();
            ++i;
        }
        return matrices;
    }

    public double transitionProbability(int i, int j, int a) {
        return ((SimpleStateDistributionTable)this.getTransitionDistributions()[i]).getProbabilityMatrix()[a][j];
    }

    public int sampleState(int i, int a) {
        return this.getTransitionDistributions()[i].generateRandomState(new Instance(a));
    }

    public int getActionCount() {
        return ((SimpleStateDistributionTable)this.getTransitionDistributions()[0]).getInputRange();
    }

    public void setInitialState(int i) {
        double[] p = new double[this.getStateCount()];
        p[i] = 1.0;
        this.setInitialStateDistribution(new SimpleStateDistribution(p));
    }

    public int sampleInitialState() {
        return this.sampleInitialState(null);
    }

    public boolean isTerminalState(int state) {
        return false;
    }
}

