/*
 * Decompiled with CFR 0.152.
 */
package rl;

import java.awt.Color;
import java.awt.Graphics;
import rl.MazeMarkovDecisionProcess;
import rl.Policy;

public class MazeMarkovDecisionProcessVisualization {
    private int RESOLUTION = 20;
    private MazeMarkovDecisionProcess mmdp;

    public MazeMarkovDecisionProcessVisualization(MazeMarkovDecisionProcess mmdp) {
        this.mmdp = mmdp;
    }

    public int getWidth() {
        return this.mmdp.getWidth() * this.RESOLUTION;
    }

    public int getHeight() {
        return this.mmdp.getHeight() * this.RESOLUTION;
    }

    public void drawMaze(Graphics g) {
        g.setColor(Color.BLACK);
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getWidth()) {
                if (this.mmdp.isObstacle(x, y)) {
                    g.fillRect(x, y, x + this.RESOLUTION, y + this.RESOLUTION);
                } else {
                    g.drawRect(x, y, x + this.RESOLUTION, y + this.RESOLUTION);
                }
                y += this.RESOLUTION;
            }
            x += this.RESOLUTION;
        }
    }

    public String toString(Policy p) {
        String ret = "";
        int y = 0;
        while (y < this.mmdp.getHeight()) {
            int x = 0;
            while (x < this.mmdp.getWidth()) {
                if (this.mmdp.isObstacle(x, y)) {
                    ret = String.valueOf(ret) + '#';
                } else {
                    int a = p.getAction(this.mmdp.stateFor(x, y));
                    switch (a) {
                        case 1: {
                            ret = String.valueOf(ret) + 'V';
                            break;
                        }
                        case 0: {
                            ret = String.valueOf(ret) + '^';
                            break;
                        }
                        case 2: {
                            ret = String.valueOf(ret) + '<';
                            break;
                        }
                        case 3: {
                            ret = String.valueOf(ret) + '>';
                        }
                    }
                }
                ++x;
            }
            ret = String.valueOf(ret) + "\n";
            ++y;
        }
        return ret;
    }

    public String toString() {
        return this.mmdp.toString();
    }
}

