/*
 * Decompiled with CFR 0.152.
 */
package rl;

import dist.Distribution;
import java.io.BufferedReader;
import java.io.FileReader;
import rl.MarkovDecisionProcess;

public class MazeMarkovDecisionProcess
implements MarkovDecisionProcess {
    private static final double FAILURE_PROBABILITY = 0.01;
    private static final int REWARD = 100;
    public static final int ACTIONS = 4;
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;
    public static final int MOVE_LEFT = 2;
    public static final int MOVE_RIGHT = 3;
    public static final char EMPTY = ' ';
    public static final char OBSTACLE = '#';
    public static final char AGENT = 'o';
    public static final char GOAL = 'x';
    private char[][] maze;
    private double motionFailureProbability;
    private int goal;
    private int initial;

    public MazeMarkovDecisionProcess(char[][] maze, int xGoal, int yGoal, int xInitial, int yInitial, double motionFailureProbability) {
        this.maze = maze;
        this.goal = this.stateFor(xGoal, yGoal);
        this.initial = this.stateFor(xInitial, yInitial);
        this.motionFailureProbability = motionFailureProbability;
    }

    public boolean isObstacle(int state) {
        return this.isObstacle(this.xFor(state), this.yFor(state));
    }

    public boolean isObstacle(int x, int y) {
        return this.maze[y][x] == '#';
    }

    public int getHeight() {
        return this.maze.length;
    }

    public int getWidth() {
        return this.maze[0].length;
    }

    public int stateFor(int x, int y) {
        return y + x * this.maze.length;
    }

    public int xFor(int state) {
        return state / this.maze.length;
    }

    public int yFor(int state) {
        return state % this.maze.length;
    }

    public int getStateCount() {
        return this.maze.length * this.maze[0].length;
    }

    public int getActionCount() {
        return 4;
    }

    public double reward(int state, int action) {
        if (state == this.goal) {
            return 100.0;
        }
        return this.transitionProbability(state, this.goal, action) * 100.0;
    }

    public double transitionProbability(int i, int j, int a) {
        int dy;
        int dx;
        int startX = this.xFor(i);
        int startY = this.yFor(i);
        int endX = this.xFor(j);
        int endY = this.yFor(j);
        if (startX != endX && startY != endY) {
            return 0.0;
        }
        switch (a) {
            case 0: {
                dx = 0;
                dy = -1;
                break;
            }
            case 1: {
                dx = 0;
                dy = 1;
                break;
            }
            case 2: {
                dx = -1;
                dy = 0;
                break;
            }
            case 3: {
                dx = 1;
                dy = 0;
                break;
            }
            default: {
                dx = 0;
                dy = 0;
            }
        }
        if (endX == startX && endY == startY) {
            if (startX + dx >= this.getWidth() || startX + dx < 0 || startY + dy >= this.getHeight() || startY + dy < 0 || this.isObstacle(startX + dx, startY + dy)) {
                return 1.0;
            }
            return this.motionFailureProbability;
        }
        if (endX == startX + dx && endY == startY + dy) {
            if (startX + dx >= this.getWidth() || startX + dx < 0 || startY + dy >= this.getHeight() || startY + dy < 0 || this.isObstacle(startX + dx, startY + dy)) {
                return 0.0;
            }
            return 1.0 - this.motionFailureProbability;
        }
        return 0.0;
    }

    public int sampleState(int i, int a) {
        if (Distribution.random.nextDouble() < this.motionFailureProbability) {
            return i;
        }
        int nextState = -1;
        switch (a) {
            case 0: {
                nextState = this.stateFor(this.xFor(i), this.yFor(i) - 1);
                break;
            }
            case 1: {
                nextState = this.stateFor(this.xFor(i), this.yFor(i) + 1);
                break;
            }
            case 2: {
                nextState = this.stateFor(this.xFor(i) - 1, this.yFor(i));
                break;
            }
            case 3: {
                nextState = this.stateFor(this.xFor(i) + 1, this.yFor(i));
                break;
            }
            default: {
                nextState = i;
            }
        }
        if (this.maze[this.yFor(nextState)][this.xFor(nextState)] == '#') {
            nextState = i;
        }
        return nextState;
    }

    public int sampleInitialState() {
        return this.initial;
    }

    public boolean isTerminalState(int state) {
        return state == this.goal;
    }

    public static MazeMarkovDecisionProcess load(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        int height = 1;
        String line = br.readLine();
        int width = line.length();
        while ((line = br.readLine()) != null) {
            ++height;
        }
        br.close();
        char[][] maze = new char[height][width];
        br = new BufferedReader(new FileReader(fileName));
        int goalX = -1;
        int goalY = -1;
        int initialX = -1;
        int initialY = -1;
        int i = 0;
        while (i < maze.length) {
            line = br.readLine();
            int j = 0;
            while (j < maze[i].length) {
                char c = line.charAt(j);
                if (c == 'o') {
                    initialX = j;
                    initialY = i;
                    maze[i][j] = 32;
                } else if (c == 'x') {
                    goalX = j;
                    goalY = i;
                    maze[i][j] = 32;
                } else {
                    maze[i][j] = c == '#' ? 35 : 32;
                }
                ++j;
            }
            ++i;
        }
        br.close();
        return new MazeMarkovDecisionProcess(maze, goalX, goalY, initialX, initialY, 0.01);
    }

    public String toString() {
        String ret = "";
        int initialX = this.xFor(this.initial);
        int initialY = this.yFor(this.initial);
        int goalX = this.xFor(this.goal);
        int goalY = this.yFor(this.goal);
        int i = 0;
        while (i < this.maze.length) {
            int j = 0;
            while (j < this.maze[i].length) {
                ret = i == initialY && j == initialX ? String.valueOf(ret) + "o" : (i == goalY && j == goalX ? String.valueOf(ret) + "x" : String.valueOf(ret) + this.maze[i][j]);
                ++j;
            }
            ret = String.valueOf(ret) + "\n";
            ++i;
        }
        return ret;
    }
}

