/*
 * Decompiled with CFR 0.152.
 */
package opt.test;

import dist.AbstractDistribution;
import dist.DiscreteDependencyTree;
import dist.DiscretePermutationDistribution;
import dist.DiscreteUniformDistribution;
import java.util.Arrays;
import java.util.Random;
import opt.GenericHillClimbingProblem;
import opt.RandomizedHillClimbing;
import opt.SimulatedAnnealing;
import opt.SwapNeighbor;
import opt.example.TravelingSalesmanCrossOver;
import opt.example.TravelingSalesmanEvaluationFunction;
import opt.example.TravelingSalesmanRouteEvaluationFunction;
import opt.example.TravelingSalesmanSortEvaluationFunction;
import opt.ga.GenericGeneticAlgorithmProblem;
import opt.ga.StandardGeneticAlgorithm;
import opt.ga.SwapMutation;
import opt.prob.GenericProbabilisticOptimizationProblem;
import opt.prob.MIMIC;
import shared.FixedIterationTrainer;

public class TravelingSalesmanTest {
    private static final int N = 50;

    public static void main(String[] args) {
        Random random = new Random();
        double[][] points = new double[50][2];
        int i = 0;
        while (i < points.length) {
            points[i][0] = random.nextDouble();
            points[i][1] = random.nextDouble();
            ++i;
        }
        TravelingSalesmanEvaluationFunction ef = new TravelingSalesmanRouteEvaluationFunction(points);
        AbstractDistribution odd = new DiscretePermutationDistribution(50);
        SwapNeighbor nf = new SwapNeighbor();
        SwapMutation mf = new SwapMutation();
        TravelingSalesmanCrossOver cf = new TravelingSalesmanCrossOver(ef);
        GenericHillClimbingProblem hcp = new GenericHillClimbingProblem(ef, odd, nf);
        GenericGeneticAlgorithmProblem gap = new GenericGeneticAlgorithmProblem(ef, odd, mf, cf);
        RandomizedHillClimbing rhc = new RandomizedHillClimbing(hcp);
        FixedIterationTrainer fit = new FixedIterationTrainer(rhc, 200000);
        fit.train();
        System.out.println(ef.value(rhc.getOptimal()));
        SimulatedAnnealing sa = new SimulatedAnnealing(1.0E12, 0.95, hcp);
        fit = new FixedIterationTrainer(sa, 200000);
        fit.train();
        System.out.println(ef.value(sa.getOptimal()));
        StandardGeneticAlgorithm ga = new StandardGeneticAlgorithm(200, 150, 20, gap);
        fit = new FixedIterationTrainer(ga, 1000);
        fit.train();
        System.out.println(ef.value(ga.getOptimal()));
        ef = new TravelingSalesmanSortEvaluationFunction(points);
        int[] ranges = new int[50];
        Arrays.fill(ranges, 50);
        odd = new DiscreteUniformDistribution(ranges);
        DiscreteDependencyTree df = new DiscreteDependencyTree(0.1, ranges);
        GenericProbabilisticOptimizationProblem pop = new GenericProbabilisticOptimizationProblem(ef, odd, df);
        MIMIC mimic = new MIMIC(200, 100, pop);
        fit = new FixedIterationTrainer(mimic, 1000);
        fit.train();
        System.out.println(ef.value(mimic.getOptimal()));
    }
}

