/*
 * Decompiled with CFR 0.152.
 */
package opt.test;

import dist.DiscreteDependencyTree;
import dist.DiscreteUniformDistribution;
import java.util.Arrays;
import java.util.Random;
import opt.DiscreteChangeOneNeighbor;
import opt.GenericHillClimbingProblem;
import opt.RandomizedHillClimbing;
import opt.SimulatedAnnealing;
import opt.example.KnapsackEvaluationFunction;
import opt.ga.DiscreteChangeOneMutation;
import opt.ga.GenericGeneticAlgorithmProblem;
import opt.ga.StandardGeneticAlgorithm;
import opt.ga.UniformCrossOver;
import opt.prob.GenericProbabilisticOptimizationProblem;
import opt.prob.MIMIC;
import shared.FixedIterationTrainer;

public class KnapsackTest {
    private static final Random random = new Random();
    private static final int NUM_ITEMS = 40;
    private static final int COPIES_EACH = 4;
    private static final double MAX_WEIGHT = 50.0;
    private static final double MAX_VOLUME = 50.0;
    private static final double KNAPSACK_VOLUME = 3200.0;

    public static void main(String[] args) {
        int[] copies = new int[40];
        Arrays.fill(copies, 4);
        double[] weights = new double[40];
        double[] volumes = new double[40];
        int i = 0;
        while (i < 40) {
            weights[i] = random.nextDouble() * 50.0;
            volumes[i] = random.nextDouble() * 50.0;
            ++i;
        }
        int[] ranges = new int[40];
        Arrays.fill(ranges, 5);
        KnapsackEvaluationFunction ef = new KnapsackEvaluationFunction(weights, volumes, 3200.0, copies);
        DiscreteUniformDistribution odd = new DiscreteUniformDistribution(ranges);
        DiscreteChangeOneNeighbor nf = new DiscreteChangeOneNeighbor(ranges);
        DiscreteChangeOneMutation mf = new DiscreteChangeOneMutation(ranges);
        UniformCrossOver cf = new UniformCrossOver();
        DiscreteDependencyTree df = new DiscreteDependencyTree(0.1, ranges);
        GenericHillClimbingProblem hcp = new GenericHillClimbingProblem(ef, odd, nf);
        GenericGeneticAlgorithmProblem gap = new GenericGeneticAlgorithmProblem(ef, odd, mf, cf);
        GenericProbabilisticOptimizationProblem pop = new GenericProbabilisticOptimizationProblem(ef, odd, df);
        RandomizedHillClimbing rhc = new RandomizedHillClimbing(hcp);
        FixedIterationTrainer fit = new FixedIterationTrainer(rhc, 200000);
        fit.train();
        System.out.println(ef.value(rhc.getOptimal()));
        SimulatedAnnealing sa = new SimulatedAnnealing(100.0, 0.95, hcp);
        fit = new FixedIterationTrainer(sa, 200000);
        fit.train();
        System.out.println(ef.value(sa.getOptimal()));
        StandardGeneticAlgorithm ga = new StandardGeneticAlgorithm(200, 150, 25, gap);
        fit = new FixedIterationTrainer(ga, 1000);
        fit.train();
        System.out.println(ef.value(ga.getOptimal()));
        MIMIC mimic = new MIMIC(200, 100, pop);
        fit = new FixedIterationTrainer(mimic, 1000);
        fit.train();
        System.out.println(ef.value(mimic.getOptimal()));
    }
}

