/*
 * Decompiled with CFR 0.152.
 */
package opt.test;

import dist.DiscreteDependencyTree;
import dist.DiscreteUniformDistribution;
import java.util.Arrays;
import opt.DiscreteChangeOneNeighbor;
import opt.GenericHillClimbingProblem;
import opt.RandomizedHillClimbing;
import opt.SimulatedAnnealing;
import opt.example.CountOnesEvaluationFunction;
import opt.ga.DiscreteChangeOneMutation;
import opt.ga.GenericGeneticAlgorithmProblem;
import opt.ga.StandardGeneticAlgorithm;
import opt.ga.UniformCrossOver;
import opt.prob.GenericProbabilisticOptimizationProblem;
import opt.prob.MIMIC;
import shared.FixedIterationTrainer;

public class CountOnesTest {
    private static final int N = 80;

    public static void main(String[] args) {
        int[] ranges = new int[80];
        Arrays.fill(ranges, 2);
        CountOnesEvaluationFunction ef = new CountOnesEvaluationFunction();
        DiscreteUniformDistribution odd = new DiscreteUniformDistribution(ranges);
        DiscreteChangeOneNeighbor nf = new DiscreteChangeOneNeighbor(ranges);
        DiscreteChangeOneMutation mf = new DiscreteChangeOneMutation(ranges);
        UniformCrossOver cf = new UniformCrossOver();
        DiscreteDependencyTree df = new DiscreteDependencyTree(0.1, ranges);
        GenericHillClimbingProblem hcp = new GenericHillClimbingProblem(ef, odd, nf);
        GenericGeneticAlgorithmProblem gap = new GenericGeneticAlgorithmProblem(ef, odd, mf, cf);
        GenericProbabilisticOptimizationProblem pop = new GenericProbabilisticOptimizationProblem(ef, odd, df);
        RandomizedHillClimbing rhc = new RandomizedHillClimbing(hcp);
        FixedIterationTrainer fit = new FixedIterationTrainer(rhc, 200);
        fit.train();
        System.out.println(ef.value(rhc.getOptimal()));
        SimulatedAnnealing sa = new SimulatedAnnealing(100.0, 0.95, hcp);
        fit = new FixedIterationTrainer(sa, 200);
        fit.train();
        System.out.println(ef.value(sa.getOptimal()));
        StandardGeneticAlgorithm ga = new StandardGeneticAlgorithm(20, 20, 0, gap);
        fit = new FixedIterationTrainer(ga, 300);
        fit.train();
        System.out.println(ef.value(ga.getOptimal()));
        MIMIC mimic = new MIMIC(50, 10, pop);
        fit = new FixedIterationTrainer(mimic, 100);
        fit.train();
        System.out.println(ef.value(mimic.getOptimal()));
    }
}

