/*
 * Decompiled with CFR 0.152.
 */
package opt.test;

import dist.DiscreteDependencyTree;
import dist.DiscreteUniformDistribution;
import java.util.Arrays;
import opt.DiscreteChangeOneNeighbor;
import opt.GenericHillClimbingProblem;
import opt.RandomizedHillClimbing;
import opt.SimulatedAnnealing;
import opt.example.ContinuousPeaksEvaluationFunction;
import opt.ga.DiscreteChangeOneMutation;
import opt.ga.GenericGeneticAlgorithmProblem;
import opt.ga.SingleCrossOver;
import opt.ga.StandardGeneticAlgorithm;
import opt.prob.GenericProbabilisticOptimizationProblem;
import opt.prob.MIMIC;
import shared.FixedIterationTrainer;

public class ContinuousPeaksTest {
    private static final int N = 60;
    private static final int T = 6;

    public static void main(String[] args) {
        int[] ranges = new int[60];
        Arrays.fill(ranges, 2);
        ContinuousPeaksEvaluationFunction ef = new ContinuousPeaksEvaluationFunction(6);
        DiscreteUniformDistribution odd = new DiscreteUniformDistribution(ranges);
        DiscreteChangeOneNeighbor nf = new DiscreteChangeOneNeighbor(ranges);
        DiscreteChangeOneMutation mf = new DiscreteChangeOneMutation(ranges);
        SingleCrossOver cf = new SingleCrossOver();
        DiscreteDependencyTree df = new DiscreteDependencyTree(0.1, ranges);
        GenericHillClimbingProblem hcp = new GenericHillClimbingProblem(ef, odd, nf);
        GenericGeneticAlgorithmProblem gap = new GenericGeneticAlgorithmProblem(ef, odd, mf, cf);
        GenericProbabilisticOptimizationProblem pop = new GenericProbabilisticOptimizationProblem(ef, odd, df);
        RandomizedHillClimbing rhc = new RandomizedHillClimbing(hcp);
        FixedIterationTrainer fit = new FixedIterationTrainer(rhc, 200000);
        fit.train();
        System.out.println(ef.value(rhc.getOptimal()));
        SimulatedAnnealing sa = new SimulatedAnnealing(1.0E11, 0.95, hcp);
        fit = new FixedIterationTrainer(sa, 200000);
        fit.train();
        System.out.println(ef.value(sa.getOptimal()));
        StandardGeneticAlgorithm ga = new StandardGeneticAlgorithm(200, 100, 10, gap);
        fit = new FixedIterationTrainer(ga, 1000);
        fit.train();
        System.out.println(ef.value(ga.getOptimal()));
        MIMIC mimic = new MIMIC(200, 20, pop);
        fit = new FixedIterationTrainer(mimic, 1000);
        fit.train();
        System.out.println(ef.value(mimic.getOptimal()));
    }
}

