/*
 * Decompiled with CFR 0.152.
 */
package opt.prob;

import dist.Distribution;
import opt.OptimizationAlgorithm;
import opt.OptimizationProblem;
import opt.prob.ProbabilisticOptimizationProblem;
import shared.DataSet;
import shared.Instance;
import util.ABAGAILArrays;

public class MIMIC
extends OptimizationAlgorithm {
    private Distribution distribution;
    private int samples;
    private int tokeep;

    public MIMIC(int samples, int tokeep, ProbabilisticOptimizationProblem op) {
        super(op);
        this.tokeep = tokeep;
        this.samples = samples;
        Instance[] data = new Instance[samples];
        int i = 0;
        while (i < data.length) {
            data[i] = op.random();
            ++i;
        }
        this.distribution = op.getDistribution();
        this.distribution.estimate(new DataSet(data));
    }

    public Instance getOptimal() {
        OptimizationProblem op = this.getOptimizationProblem();
        Instance[] data = new Instance[this.samples];
        int i = 0;
        while (i < data.length) {
            data[i] = this.distribution.sample(null);
            ++i;
        }
        double bestVal = op.value(data[0]);
        Instance best = data[0];
        int i2 = 1;
        while (i2 < data.length) {
            double value = op.value(data[i2]);
            if (value > bestVal) {
                bestVal = value;
                best = data[i2];
            }
            ++i2;
        }
        return best;
    }

    public double train() {
        ProbabilisticOptimizationProblem op = (ProbabilisticOptimizationProblem)this.getOptimizationProblem();
        Instance[] data = new Instance[this.samples];
        int i = 0;
        while (i < data.length) {
            data[i] = this.distribution.sample(null);
            ++i;
        }
        double[] values = new double[data.length];
        int i2 = 0;
        while (i2 < data.length) {
            values[i2] = op.value(data[i2]);
            ++i2;
        }
        double[] temp = new double[values.length];
        System.arraycopy(values, 0, temp, 0, temp.length);
        double cutoff = ABAGAILArrays.randomizedSelect(temp, temp.length - this.tokeep);
        int j = 0;
        Instance[] kept = new Instance[this.tokeep];
        int i3 = 0;
        while (i3 < data.length && j < kept.length) {
            if (values[i3] >= cutoff) {
                kept[j] = data[i3];
                ++j;
            }
            ++i3;
        }
        this.distribution.estimate(new DataSet(kept));
        return cutoff;
    }
}

