/*
 * Decompiled with CFR 0.152.
 */
package opt.ga;

import dist.DiscreteDistribution;
import java.util.Random;
import opt.OptimizationAlgorithm;
import opt.ga.GeneticAlgorithmProblem;
import shared.Instance;

public class StandardGeneticAlgorithm
extends OptimizationAlgorithm {
    private static final Random random = new Random();
    private int populationSize;
    private int toMate;
    private int toMutate;
    private Instance[] population;
    private double[] values;

    public StandardGeneticAlgorithm(int populationSize, int toMate, int toMutate, GeneticAlgorithmProblem gap) {
        super(gap);
        this.toMate = toMate;
        this.toMutate = toMutate;
        this.populationSize = populationSize;
        this.population = new Instance[populationSize];
        int i = 0;
        while (i < this.population.length) {
            this.population[i] = gap.random();
            ++i;
        }
        this.values = new double[populationSize];
        i = 0;
        while (i < this.values.length) {
            this.values[i] = gap.value(this.population[i]);
            ++i;
        }
    }

    public double train() {
        GeneticAlgorithmProblem ga = (GeneticAlgorithmProblem)this.getOptimizationProblem();
        double[] probabilities = new double[this.population.length];
        double sum = 0.0;
        int i = 0;
        while (i < probabilities.length) {
            probabilities[i] = this.values[i];
            sum += probabilities[i];
            ++i;
        }
        if (Double.isInfinite(sum)) {
            return sum;
        }
        i = 0;
        while (i < probabilities.length) {
            int n = i++;
            probabilities[n] = probabilities[n] / sum;
        }
        DiscreteDistribution dd = new DiscreteDistribution(probabilities);
        double[] newValues = new double[this.populationSize];
        Instance[] newPopulation = new Instance[this.populationSize];
        int i2 = 0;
        while (i2 < this.toMate) {
            Instance a = this.population[dd.sample(null).getDiscrete()];
            Instance b = this.population[dd.sample(null).getDiscrete()];
            newPopulation[i2] = ga.mate(a, b);
            newValues[i2] = -1.0;
            ++i2;
        }
        i2 = this.toMate;
        while (i2 < newPopulation.length) {
            int j = dd.sample(null).getDiscrete();
            newPopulation[i2] = this.population[j];
            newValues[i2] = this.values[j];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.toMutate) {
            ga.mutate(newPopulation[random.nextInt(newPopulation.length)]);
            newValues[i2] = -1.0;
            ++i2;
        }
        i2 = 0;
        while (i2 < newValues.length) {
            if (newValues[i2] == -1.0) {
                newValues[i2] = ga.value(newPopulation[i2]);
            }
            ++i2;
        }
        this.population = newPopulation;
        this.values = newValues;
        return sum / (double)this.populationSize;
    }

    public Instance getOptimal() {
        GeneticAlgorithmProblem ga = (GeneticAlgorithmProblem)this.getOptimizationProblem();
        double bestVal = this.values[0];
        int best = 0;
        int i = 1;
        while (i < this.population.length) {
            double value = this.values[i];
            if (value > bestVal) {
                bestVal = value;
                best = i;
            }
            ++i;
        }
        return this.population[best];
    }
}

